/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;

public final class ProjectionResult {
    private final String projectionName;
    private final Model model;
    private final Map<String, FileManifest> pluginManifests;
    private final List<ValidationEvent> events;

    private ProjectionResult(Builder builder) {
        this.projectionName = (String)SmithyBuilder.requiredState((String)"projectionName", (Object)builder.projectionName);
        this.model = (Model)SmithyBuilder.requiredState((String)"model", (Object)builder.model);
        this.events = (List)builder.events.copy();
        this.pluginManifests = (Map)builder.pluginManifests.copy();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getProjectionName() {
        return this.projectionName;
    }

    public Model getModel() {
        return this.model;
    }

    public boolean isBroken() {
        for (ValidationEvent e : this.events) {
            if (e.getSeverity() != Severity.ERROR && e.getSeverity() != Severity.DANGER) continue;
            return true;
        }
        return false;
    }

    public List<ValidationEvent> getEvents() {
        return this.events;
    }

    public Map<String, FileManifest> getPluginManifests() {
        return this.pluginManifests;
    }

    public Optional<FileManifest> getPluginManifest(String artifactName) {
        return Optional.ofNullable(this.pluginManifests.get(artifactName));
    }

    public static final class Builder
    implements SmithyBuilder<ProjectionResult> {
        private String projectionName;
        private Model model;
        private final BuilderRef<Map<String, FileManifest>> pluginManifests = BuilderRef.forUnorderedMap();
        private final BuilderRef<List<ValidationEvent>> events = BuilderRef.forList();

        public ProjectionResult build() {
            return new ProjectionResult(this);
        }

        public Builder model(Model model) {
            this.model = model;
            return this;
        }

        public Builder projectionName(String projectionName) {
            this.projectionName = projectionName;
            return this;
        }

        public Builder addPluginManifest(String artifactName, FileManifest manifest) {
            ((Map)this.pluginManifests.get()).put(artifactName, manifest);
            return this;
        }

        public Builder addEvent(ValidationEvent event) {
            ((List)this.events.get()).add(Objects.requireNonNull(event));
            return this;
        }

        public Builder events(List<ValidationEvent> events) {
            this.events.clear();
            events.forEach(this::addEvent);
            return this;
        }
    }
}

