/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.Collections;
import java.util.Set;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.build.transforms.BackwardCompatHelper;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.transform.ModelTransformer;

public final class IncludeMetadata
extends BackwardCompatHelper<Config> {
    @Override
    public Class<Config> getConfigType() {
        return Config.class;
    }

    @Override
    public String getName() {
        return "includeMetadata";
    }

    @Override
    String getBackwardCompatibleNameMapping() {
        return "keys";
    }

    @Override
    protected Model transformWithConfig(TransformContext context, Config config) {
        Model model = context.getModel();
        ModelTransformer transformer = context.getTransformer();
        Set<String> keys = config.getKeys();
        return transformer.filterMetadata(model, (key, value) -> keys.contains(key));
    }

    public static final class Config {
        private Set<String> keys = Collections.emptySet();

        public Set<String> getKeys() {
            return this.keys;
        }

        public void setKeys(Set<String> keys) {
            this.keys = keys;
        }
    }
}

