/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.Collections;
import java.util.Set;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.build.transforms.BackwardCompatHelper;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.transform.ModelTransformer;

public final class IncludeServices
extends BackwardCompatHelper<Config> {
    @Override
    public Class<Config> getConfigType() {
        return Config.class;
    }

    @Override
    public String getName() {
        return "includeServices";
    }

    @Override
    String getBackwardCompatibleNameMapping() {
        return "services";
    }

    @Override
    protected Model transformWithConfig(TransformContext context, Config config) {
        Set<ShapeId> services = config.getServices();
        Model model = context.getModel();
        ModelTransformer transformer = context.getTransformer();
        return transformer.filterShapes(model, shape -> !shape.isServiceShape() || services.contains(shape.getId()));
    }

    public static final class Config {
        private Set<ShapeId> services = Collections.emptySet();

        public Set<ShapeId> getServices() {
            return this.services;
        }

        public void setServices(Set<ShapeId> services) {
            this.services = services;
        }
    }
}

