/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.build.transforms.BackwardCompatHelper;
import software.amazon.smithy.build.transforms.TraitRemovalUtils;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.Pair;

public final class ExcludeTraits
extends BackwardCompatHelper<Config> {
    private static final Logger LOGGER = Logger.getLogger(ExcludeTraits.class.getName());

    @Override
    public Class<Config> getConfigType() {
        return Config.class;
    }

    @Override
    public String getName() {
        return "excludeTraits";
    }

    @Override
    String getBackwardCompatibleNameMapping() {
        return "traits";
    }

    @Override
    public Model transformWithConfig(TransformContext context, Config config) {
        Pair<Set<ShapeId>, Set<String>> namesAndNamespaces = TraitRemovalUtils.parseTraits(config.getTraits());
        Set names = (Set)namesAndNamespaces.getLeft();
        Set namespaces = (Set)namesAndNamespaces.getRight();
        LOGGER.info(() -> "Excluding traits by ID " + names + " and namespaces " + namespaces);
        Model model = context.getModel();
        ModelTransformer transformer = context.getTransformer();
        Set removeTraits = model.getShapesWithTrait(TraitDefinition.class).stream().filter(trait -> TraitRemovalUtils.matchesTraitDefinition(trait, names, namespaces)).collect(Collectors.toSet());
        if (!removeTraits.isEmpty()) {
            LOGGER.info(() -> "Excluding traits: " + removeTraits);
        }
        return transformer.removeShapes(model, removeTraits);
    }

    public static final class Config {
        private Set<String> traits = Collections.emptySet();

        public Set<String> getTraits() {
            return this.traits;
        }

        public void setTraits(Set<String> traits) {
            this.traits = traits;
        }
    }
}

