/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.smithy.build.SmithyBuildException;
import software.amazon.smithy.build.model.TransformConfig;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ProjectionConfig
implements ToSmithyBuilder<ProjectionConfig> {
    private final boolean isAbstract;
    private final List<String> imports;
    private final List<TransformConfig> transforms;
    private final Map<String, ObjectNode> plugins;

    private ProjectionConfig(Builder builder) {
        this.imports = (List)builder.imports.copy();
        this.transforms = (List)builder.transforms.copy();
        this.isAbstract = builder.isAbstract;
        this.plugins = (Map)builder.plugins.copy();
        if (!(!this.isAbstract || this.plugins.isEmpty() && this.imports.isEmpty())) {
            throw new SmithyBuildException("Abstract projections must not define plugins or imports");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ProjectionConfig.builder().imports(this.imports).plugins(this.plugins).transforms(this.transforms).setAbstract(this.isAbstract);
    }

    public List<TransformConfig> getTransforms() {
        return this.transforms;
    }

    public Map<String, ObjectNode> getPlugins() {
        return this.plugins;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public static final class Builder
    implements SmithyBuilder<ProjectionConfig> {
        private boolean isAbstract;
        private final BuilderRef<List<String>> imports = BuilderRef.forList();
        private final BuilderRef<List<TransformConfig>> transforms = BuilderRef.forList();
        private final BuilderRef<Map<String, ObjectNode>> plugins = BuilderRef.forOrderedMap();

        private Builder() {
        }

        public ProjectionConfig build() {
            return new ProjectionConfig(this);
        }

        public Builder setAbstract(boolean isAbstract) {
            this.isAbstract = isAbstract;
            return this;
        }

        public Builder imports(Collection<String> imports) {
            this.imports.clear();
            ((List)this.imports.get()).addAll(imports);
            return this;
        }

        public Builder transforms(Collection<TransformConfig> transforms) {
            this.transforms.clear();
            ((List)this.transforms.get()).addAll(transforms);
            return this;
        }

        public Builder plugins(Map<String, ObjectNode> plugins) {
            this.plugins.clear();
            ((Map)this.plugins.get()).putAll(plugins);
            return this;
        }
    }
}

