/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.model;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.build.model.ConfigLoader;
import software.amazon.smithy.build.model.ProjectionConfig;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class SmithyBuildConfig
implements ToSmithyBuilder<SmithyBuildConfig> {
    private static final Set<String> BUILTIN_PLUGINS = SetUtils.of((Object[])new String[]{"build-info", "model", "sources"});
    private final String version;
    private final List<String> imports;
    private final String outputDirectory;
    private final Map<String, ProjectionConfig> projections;
    private final Map<String, ObjectNode> plugins;
    private final boolean ignoreMissingPlugins;

    private SmithyBuildConfig(Builder builder) {
        SmithyBuilder.requiredState((String)"version", (Object)builder.version);
        this.version = builder.version;
        this.outputDirectory = builder.outputDirectory;
        this.imports = (List)builder.imports.copy();
        this.projections = (Map)builder.projections.copy();
        this.plugins = (Map)builder.plugins.copy();
        this.ignoreMissingPlugins = builder.ignoreMissingPlugins;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SmithyBuildConfig load(Path file) {
        return SmithyBuildConfig.builder().load(file).build();
    }

    public Builder toBuilder() {
        return SmithyBuildConfig.builder().version(this.version).outputDirectory(this.outputDirectory).imports(this.imports).projections(this.projections).plugins(this.plugins).ignoreMissingPlugins(this.ignoreMissingPlugins);
    }

    public String getVersion() {
        return this.version;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public Optional<String> getOutputDirectory() {
        return Optional.ofNullable(this.outputDirectory);
    }

    public Map<String, ProjectionConfig> getProjections() {
        return Collections.unmodifiableMap(this.projections);
    }

    public Map<String, ObjectNode> getPlugins() {
        return Collections.unmodifiableMap(this.plugins);
    }

    public boolean isIgnoreMissingPlugins() {
        return this.ignoreMissingPlugins;
    }

    public static final class Builder
    implements SmithyBuilder<SmithyBuildConfig> {
        private final BuilderRef<List<String>> imports = BuilderRef.forList();
        private final BuilderRef<Map<String, ProjectionConfig>> projections = BuilderRef.forOrderedMap();
        private final BuilderRef<Map<String, ObjectNode>> plugins = BuilderRef.forOrderedMap();
        private String version;
        private String outputDirectory;
        private boolean ignoreMissingPlugins;

        Builder() {
        }

        public SmithyBuildConfig build() {
            for (String builtin : BUILTIN_PLUGINS) {
                ((Map)this.plugins.get()).put(builtin, Node.objectNode());
            }
            return new SmithyBuildConfig(this);
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder load(Path config) {
            return this.merge(ConfigLoader.load(config));
        }

        public Builder merge(SmithyBuildConfig config) {
            config.getOutputDirectory().ifPresent(this::outputDirectory);
            this.version(config.getVersion());
            ((List)this.imports.get()).addAll(config.getImports());
            ((Map)this.projections.get()).putAll(config.getProjections());
            ((Map)this.plugins.get()).putAll(config.getPlugins());
            if (config.isIgnoreMissingPlugins()) {
                this.ignoreMissingPlugins(config.ignoreMissingPlugins);
            }
            return this;
        }

        public Builder outputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        public Builder imports(Collection<String> imports) {
            this.imports.clear();
            ((List)this.imports.get()).addAll(imports);
            return this;
        }

        public Builder projections(Map<String, ProjectionConfig> projections) {
            this.projections.clear();
            ((Map)this.projections.get()).putAll(projections);
            return this;
        }

        public Builder plugins(Map<String, ObjectNode> plugins) {
            this.plugins.clear();
            ((Map)this.plugins.get()).putAll(plugins);
            return this;
        }

        public Builder ignoreMissingPlugins(boolean ignoreMissingPlugins) {
            this.ignoreMissingPlugins = ignoreMissingPlugins;
            return this;
        }
    }
}

