/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.build.SmithyBuildException;

final class DefaultFileManifest
implements FileManifest {
    private final Set<Path> files = new ConcurrentSkipListSet<Path>(Comparator.comparing(Path::toString));
    private final Path baseDir;

    DefaultFileManifest(Path baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public Path getBaseDir() {
        return this.baseDir;
    }

    @Override
    public Set<Path> getFiles() {
        return new LinkedHashSet<Path>(this.files);
    }

    @Override
    public Path addFile(Path path) {
        Path parent;
        Objects.requireNonNull(path);
        if (!path.startsWith(this.baseDir) || !path.isAbsolute()) {
            path = this.resolvePath(path);
        }
        if ((parent = path.getParent()) != null) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new SmithyBuildException(String.format("Error create directory `%s`: %s", parent, e.getMessage()));
            }
        }
        this.files.add(path);
        return path;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Path writeFile(Path path, Reader fileContentsReader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Path writeFile(Path path, InputStream fileContentsInputStream) {
        path = this.addFile(path);
        try {
            Files.copy(fileContentsInputStream, path, StandardCopyOption.REPLACE_EXISTING);
            return path;
        }
        catch (IOException e) {
            throw new SmithyBuildException("Unable to write contents of file `" + path + "`: " + e.getMessage(), e);
        }
    }
}

