/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.List;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.build.transforms.BackwardCompatHelper;
import software.amazon.smithy.model.Model;

public final class Apply
extends BackwardCompatHelper<Config> {
    @Override
    public Class<Config> getConfigType() {
        return Config.class;
    }

    @Override
    public String getName() {
        return "apply";
    }

    @Override
    String getBackwardCompatibleNameMapping() {
        return "projections";
    }

    @Override
    protected Model transformWithConfig(TransformContext context, Config config) {
        for (String projection : config.getProjections()) {
            context.enqueueProjection(projection);
        }
        return context.getModel();
    }

    public static final class Config {
        private List<String> projections;

        public List<String> getProjections() {
            return this.projections;
        }

        public void setProjections(List<String> projections) {
            this.projections = projections;
        }
    }
}

