/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.build.PluginContext;
import software.amazon.smithy.build.SmithyBuildPlugin;
import software.amazon.smithy.build.SourcesConflictException;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.ModelDiscovery;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ModelSerializer;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.IoUtils;
import software.amazon.smithy.utils.ListUtils;

public final class SourcesPlugin
implements SmithyBuildPlugin {
    private static final String NAME = "sources";
    private static final String PROJECTED_FILENAME = "model.json";
    private static final Logger LOGGER = Logger.getLogger(SourcesPlugin.class.getName());

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void execute(PluginContext context) {
        List names;
        if (!context.getOriginalModel().isPresent()) {
            LOGGER.warning("No original model was provided, so the sources plugin cannot run");
            return;
        }
        String projectionName = context.getProjectionName();
        if (projectionName.equals("source")) {
            names = SourcesPlugin.copySources(context);
            LOGGER.fine(() -> String.format("Copying source files to the sources of %s: %s", projectionName, names));
        } else {
            LOGGER.fine(() -> String.format("Creating the `%s` sources by extracting relevant components from the original model", projectionName));
            names = ListUtils.of((Object)PROJECTED_FILENAME);
            SourcesPlugin.projectSources(context);
        }
        if (names.isEmpty()) {
            LOGGER.info(String.format("Skipping `%s` manifest because no Smithy sources found", projectionName));
        } else {
            LOGGER.fine(() -> String.format("Writing `%s` manifest", projectionName));
            context.getFileManifest().writeFile("manifest", String.join((CharSequence)"\n", names) + "\n");
        }
    }

    private static List<String> copySources(PluginContext context) {
        ArrayList<String> names = new ArrayList<String>();
        context.getSources().forEach(path -> SourcesPlugin.copyDirectory(names, context.getFileManifest(), path, path));
        return names;
    }

    private static void copyDirectory(List<String> names, FileManifest manifest, Path root, Path current) {
        try {
            if (Files.isDirectory(current, new LinkOption[0])) {
                Files.list(current).filter(p -> !p.equals(current)).filter(p -> Files.isDirectory(p, new LinkOption[0]) || Files.isRegularFile(p, new LinkOption[0])).forEach(p -> SourcesPlugin.copyDirectory(names, manifest, root, p));
            } else if (Files.isRegularFile(current, new LinkOption[0])) {
                if (current.toString().endsWith(".jar")) {
                    String jarRoot = root.equals(current) ? "" : root.relativize(current).toString() + File.separator;
                    SourcesPlugin.copyModelsFromJar(names, manifest, jarRoot, current);
                } else {
                    Path target = root.equals(current) ? current.getFileName() : root.relativize(current);
                    SourcesPlugin.copyFile(names, manifest, target, IoUtils.readUtf8File((Path)current));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading the contents of " + current + ": " + e.getMessage(), e);
        }
    }

    private static void copyFile(List<String> names, FileManifest manifest, Path target, String contents) {
        if (target == null) {
            return;
        }
        if (manifest.hasFile(target)) {
            throw new SourcesConflictException("Source file conflict found when attempting to add `" + target + "` to the `sources` plugin output. All sources must have unique filenames relative to the directories marked as a 'source'. The files and directories that make up sources are flattened into a single directory and conflicts are not allowed. The manifest has the following files: " + ValidationUtils.tickedList(manifest.getFiles()));
        }
        manifest.writeFile(target, contents);
        names.add(target.toString());
    }

    private static void projectSources(PluginContext context) {
        Model updatedModel = context.getModel();
        ObjectNode serialized = ModelSerializer.builder().shapeFilter(context::isSourceShape).metadataFilter(context::isSourceMetadata).build().serialize(updatedModel);
        context.getFileManifest().writeJson(PROJECTED_FILENAME, (Node)serialized);
    }

    private static void copyModelsFromJar(List<String> names, FileManifest manifest, String jarRoot, Path jarPath) throws IOException {
        LOGGER.fine(() -> "Copying models from JAR " + jarPath);
        URL manifestUrl = ModelDiscovery.createSmithyJarManifestUrl((String)jarPath.toString());
        String prefix = SourcesPlugin.computeJarFilePrefix(jarRoot, jarPath);
        for (URL model : ModelDiscovery.findModels((URL)manifestUrl)) {
            String name = ModelDiscovery.getSmithyModelPathFromJarUrl((URL)model);
            Path target = Paths.get(prefix + name, new String[0]);
            LOGGER.finer(() -> "Copying " + name + " from JAR to " + target);
            InputStream is = model.openStream();
            try {
                SourcesPlugin.copyFile(names, manifest, target, IoUtils.toUtf8String((InputStream)is));
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    private static String computeJarFilePrefix(String jarRoot, Path jarPath) {
        Path jarFilenamePath = jarPath.getFileName();
        if (jarFilenamePath == null) {
            return jarRoot;
        }
        String jarFilename = jarFilenamePath.toString();
        return jarRoot + jarFilename.substring(0, jarFilename.length() - ".jar".length()) + File.separator;
    }
}

