/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.smithy.build.SmithyBuildException;
import software.amazon.smithy.build.model.TransformConfig;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;

public final class ProjectionConfig {
    private final boolean isAbstract;
    private final List<String> imports;
    private final List<TransformConfig> transforms;
    private final Map<String, ObjectNode> plugins;

    private ProjectionConfig(Builder builder) {
        this.imports = ListUtils.copyOf((Collection)builder.imports);
        this.transforms = ListUtils.copyOf((Collection)builder.transforms);
        this.isAbstract = builder.isAbstract;
        this.plugins = MapUtils.copyOf((Map)builder.plugins);
        if (!(!this.isAbstract || this.plugins.isEmpty() && this.imports.isEmpty())) {
            throw new SmithyBuildException("Abstract projections must not define plugins or imports");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<TransformConfig> getTransforms() {
        return this.transforms;
    }

    public Map<String, ObjectNode> getPlugins() {
        return this.plugins;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public static final class Builder
    implements SmithyBuilder<ProjectionConfig> {
        private boolean isAbstract;
        private final List<String> imports = new ArrayList<String>();
        private final List<TransformConfig> transforms = new ArrayList<TransformConfig>();
        private final Map<String, ObjectNode> plugins = new HashMap<String, ObjectNode>();

        private Builder() {
        }

        public ProjectionConfig build() {
            return new ProjectionConfig(this);
        }

        public Builder setAbstract(boolean isAbstract) {
            this.isAbstract = isAbstract;
            return this;
        }

        public Builder imports(Collection<String> imports) {
            this.imports.clear();
            this.imports.addAll(imports);
            return this;
        }

        public Builder transforms(Collection<TransformConfig> transforms) {
            this.transforms.clear();
            this.transforms.addAll(transforms);
            return this;
        }

        public Builder plugins(Map<String, ObjectNode> plugins) {
            this.plugins.clear();
            this.plugins.putAll(plugins);
            return this;
        }
    }
}

