/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.build.transforms.AbstractTraitRemoval;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.Pair;

public final class ExcludeTraits
extends AbstractTraitRemoval {
    private static final Logger LOGGER = Logger.getLogger(ExcludeTraits.class.getName());

    @Override
    public String getName() {
        return "excludeTraits";
    }

    @Override
    public BiFunction<ModelTransformer, Model, Model> createTransformer(List<String> arguments) {
        Pair<Set<ShapeId>, Set<String>> namesAndNamespaces = this.parseTraits(arguments);
        Set names = (Set)namesAndNamespaces.getLeft();
        Set namespaces = (Set)namesAndNamespaces.getRight();
        LOGGER.info(() -> "Excluding traits by ID " + names + " and namespaces " + namespaces);
        return (transformer, model) -> {
            Set removeTraits = model.getTraitShapes().stream().filter(trait -> this.matchesTraitDefinition((Shape)trait, names, namespaces)).collect(Collectors.toSet());
            if (!removeTraits.isEmpty()) {
                LOGGER.info(() -> "Excluding traits: " + removeTraits);
            }
            return transformer.removeShapes(model, removeTraits);
        };
    }
}

