/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.build.ProjectionResult;
import software.amazon.smithy.build.ProjectionTransformer;
import software.amazon.smithy.build.SmithyBuildException;
import software.amazon.smithy.build.SmithyBuildImpl;
import software.amazon.smithy.build.SmithyBuildPlugin;
import software.amazon.smithy.build.SmithyBuildResult;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.transform.ModelTransformer;

public final class SmithyBuild {
    SmithyBuildConfig config;
    Path importBasePath;
    Path outputDirectory;
    Function<String, Optional<ProjectionTransformer>> transformFactory;
    Function<String, Optional<SmithyBuildPlugin>> pluginFactory;
    Function<Path, FileManifest> fileManifestFactory;
    Supplier<ModelAssembler> modelAssemblerSupplier;
    ModelTransformer modelTransformer;
    Model model;
    ClassLoader pluginClassLoader;
    Set<Path> sources = new HashSet<Path>();
    Predicate<String> projectionFilter = name -> true;
    Predicate<String> pluginFilter = name -> true;

    public SmithyBuild() {
    }

    public SmithyBuild(SmithyBuildConfig config) {
        this.config(config);
    }

    public static SmithyBuild create(ClassLoader classLoader) {
        ModelAssembler assembler = Model.assembler((ClassLoader)classLoader);
        return SmithyBuild.create(classLoader, () -> ((ModelAssembler)assembler).copy());
    }

    public static SmithyBuild create(ClassLoader classLoader, Supplier<ModelAssembler> modelAssemblerSupplier) {
        return new SmithyBuild().modelAssemblerSupplier(modelAssemblerSupplier).modelTransformer(ModelTransformer.createWithServiceProviders((ClassLoader)classLoader)).transformFactory(ProjectionTransformer.createServiceFactory(classLoader)).pluginFactory(SmithyBuildPlugin.createServiceFactory(classLoader)).pluginClassLoader(classLoader);
    }

    public SmithyBuildResult build() {
        SmithyBuildResult.Builder resultBuilder = SmithyBuildResult.builder();
        Map errors = Collections.synchronizedMap(new TreeMap());
        this.build(resultBuilder::addProjectionResult, errors::put);
        if (!errors.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append(errors.size()).append(" Smithy build projections failed.");
            message.append(System.lineSeparator()).append(System.lineSeparator());
            for (Map.Entry e : errors.entrySet()) {
                message.append("(").append((String)e.getKey()).append("): ").append(e.getValue()).append(System.lineSeparator());
            }
            SmithyBuildException buildException = new SmithyBuildException(message.toString());
            errors.values().forEach(buildException::addSuppressed);
            throw buildException;
        }
        return resultBuilder.build();
    }

    public void build(Consumer<ProjectionResult> resultCallback, BiConsumer<String, Throwable> exceptionCallback) {
        new SmithyBuildImpl(this).applyAllProjections(resultCallback, exceptionCallback);
    }

    public SmithyBuild config(SmithyBuildConfig config) {
        this.config = config;
        config.getImportBasePath().ifPresent(this::importBasePath);
        return this;
    }

    public SmithyBuild config(Path configPath) {
        return this.config(SmithyBuildConfig.load(configPath));
    }

    public SmithyBuild model(Model model) {
        this.model = model;
        return this;
    }

    public SmithyBuild importBasePath(Path importBasePath) {
        this.importBasePath = importBasePath;
        return this;
    }

    public SmithyBuild outputDirectory(Path outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }

    public SmithyBuild outputDirectory(String outputDirectory) {
        return this.outputDirectory(Paths.get(outputDirectory, new String[0]));
    }

    public SmithyBuild fileManifestFactory(Function<Path, FileManifest> fileManifestFactory) {
        this.fileManifestFactory = fileManifestFactory;
        return this;
    }

    public SmithyBuild modelAssemblerSupplier(Supplier<ModelAssembler> modelAssemblerSupplier) {
        this.modelAssemblerSupplier = modelAssemblerSupplier;
        return this;
    }

    public SmithyBuild modelTransformer(ModelTransformer modelTransformer) {
        this.modelTransformer = modelTransformer;
        return this;
    }

    public SmithyBuild transformFactory(Function<String, Optional<ProjectionTransformer>> transformFactory) {
        this.transformFactory = transformFactory;
        return this;
    }

    public SmithyBuild pluginFactory(Function<String, Optional<SmithyBuildPlugin>> pluginFactory) {
        this.pluginFactory = pluginFactory;
        return this;
    }

    public SmithyBuild pluginClassLoader(ClassLoader pluginClassLoader) {
        this.pluginClassLoader = pluginClassLoader;
        return this;
    }

    public SmithyBuild registerSources(Path ... pathToSources) {
        Collections.addAll(this.sources, pathToSources);
        return this;
    }

    public SmithyBuild projectionFilter(Predicate<String> projectionFilter) {
        this.projectionFilter = Objects.requireNonNull(projectionFilter);
        return this;
    }

    public SmithyBuild pluginFilter(Predicate<String> pluginFilter) {
        this.pluginFilter = Objects.requireNonNull(pluginFilter);
        return this;
    }
}

