/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import software.amazon.smithy.build.ProjectionTransformer;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.Pair;

abstract class AbstractTraitRemoval
implements ProjectionTransformer {
    AbstractTraitRemoval() {
    }

    Pair<Set<ShapeId>, Set<String>> parseTraits(List<String> arguments) {
        HashSet<ShapeId> traitNames = new HashSet<ShapeId>();
        HashSet<String> traitNamespaces = new HashSet<String>();
        for (String arg : arguments) {
            if (arg.endsWith("#")) {
                traitNamespaces.add(arg.substring(0, arg.length() - 1));
                continue;
            }
            if (arg.equals("smithy.api")) {
                traitNamespaces.add(arg);
                continue;
            }
            traitNames.add(ShapeId.from((String)Trait.makeAbsoluteName((String)arg)));
        }
        return Pair.of(traitNames, traitNamespaces);
    }

    boolean matchesTraitDefinition(Shape traitShape, Set<ShapeId> traitNames, Set<String> traitNamespaces) {
        return traitNames.contains(traitShape.getId()) || traitNamespaces.contains(traitShape.getId().getNamespace());
    }
}

