/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import software.amazon.smithy.build.ProjectionTransformer;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.transform.ModelTransformer;

public final class IncludeShapesByTag
implements ProjectionTransformer {
    @Override
    public String getName() {
        return "includeShapesByTag";
    }

    @Override
    public Collection<String> getAliases() {
        return Collections.singleton("includeByTag");
    }

    @Override
    public BiFunction<ModelTransformer, Model, Model> createTransformer(List<String> arguments) {
        HashSet<String> includeTags = new HashSet<String>(arguments);
        return (transformer, model) -> transformer.filterShapes(model, shape -> {
            if (Prelude.isPreludeShape((ToShapeId)shape)) return true;
            if (!shape.getTags().stream().anyMatch(includeTags::contains)) return false;
            return true;
        });
    }
}

