/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import software.amazon.smithy.build.ProjectionTransformer;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.AuthTrait;
import software.amazon.smithy.model.traits.Protocol;
import software.amazon.smithy.model.traits.ProtocolsTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.ListUtils;

public final class IncludeAuth
implements ProjectionTransformer {
    @Override
    public String getName() {
        return "includeAuth";
    }

    public List<String> getAliases() {
        return ListUtils.of((Object)"includeAuthentication");
    }

    @Override
    public BiFunction<ModelTransformer, Model, Model> createTransformer(List<String> arguments) {
        HashSet<String> includeNames = new HashSet<String>(arguments);
        return (transformer, model) -> transformer.mapShapes(model, shape -> {
            Shape result = shape.getTrait(AuthTrait.class).map(authTrait -> IncludeAuth.updateShapeAuth(shape, authTrait, includeNames)).orElse((Shape)shape);
            return result.getTrait(ProtocolsTrait.class).map(protocolsTrait -> IncludeAuth.updateProtocolsTrait(result, protocolsTrait, includeNames)).orElse(result);
        });
    }

    private static Shape updateShapeAuth(Shape shape, AuthTrait authTrait, Set<String> includeNames) {
        Set<String> names = IncludeAuth.getIntersection(authTrait.getValues(), includeNames);
        if (names.size() == authTrait.getValues().size()) {
            return shape;
        }
        AuthTrait.Builder builder = AuthTrait.builder();
        builder.clearValues();
        authTrait.getValues().stream().filter(names::contains).forEach(arg_0 -> ((AuthTrait.Builder)builder).addValue(arg_0));
        return (Shape)Shape.shapeToBuilder((Shape)shape).addTrait((Trait)builder.build()).build();
    }

    private static Set<String> getIntersection(Collection<String> values, Set<String> includeNames) {
        HashSet<String> names = new HashSet<String>(values);
        names.retainAll(includeNames);
        return names;
    }

    private static Shape updateProtocolsTrait(Shape shape, ProtocolsTrait trait, Set<String> includeNames) {
        HashSet schemes = new HashSet(trait.getAllAuthSchemes());
        schemes.removeAll(includeNames);
        if (schemes.isEmpty()) {
            return shape;
        }
        ProtocolsTrait.Builder protocolTraitBuilder = trait.toBuilder().clearProtocols();
        for (Protocol protocol : trait.getProtocols()) {
            Protocol.Builder protocolBuilder = protocol.toBuilder();
            protocolBuilder.clearAuth();
            for (String auth : protocol.getAuth()) {
                if (!includeNames.contains(auth)) continue;
                protocolBuilder.addAuth(auth);
            }
            protocolTraitBuilder.addProtocol(protocolBuilder.build());
        }
        return (Shape)Shape.shapeToBuilder((Shape)shape).addTrait((Trait)protocolTraitBuilder.build()).build();
    }
}

