/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import software.amazon.smithy.build.ProjectionTransformer;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.transform.ModelTransformer;

public final class RemoveUnusedShapes
implements ProjectionTransformer {
    @Override
    public String getName() {
        return "removeUnusedShapes";
    }

    @Override
    public Collection<String> getAliases() {
        return Collections.singleton("treeShaker");
    }

    @Override
    public BiFunction<ModelTransformer, Model, Model> createTransformer(List<String> arguments) {
        HashSet<String> includeTags = new HashSet<String>(arguments);
        Predicate<Shape> keepShapesByTag = shape -> includeTags.stream().noneMatch(arg_0 -> ((Shape)shape).hasTag(arg_0));
        Predicate<Shape> keepTraitDefsByTag = trait -> includeTags.stream().noneMatch(arg_0 -> ((Shape)trait).hasTag(arg_0));
        return (transformer, model) -> {
            int currentShapeCount;
            do {
                currentShapeCount = model.toSet().size();
                model = transformer.removeUnreferencedShapes(model, keepShapesByTag);
            } while (currentShapeCount != (model = transformer.removeUnreferencedTraitDefinitions(model, keepTraitDefsByTag)).toSet().size());
            return model;
        };
    }
}

