/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.build.transforms.AbstractTraitRemoval;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.Pair;

public final class IncludeTraits
extends AbstractTraitRemoval {
    private static final Logger LOGGER = Logger.getLogger(IncludeTraits.class.getName());

    @Override
    public String getName() {
        return "includeTraits";
    }

    @Override
    public BiFunction<ModelTransformer, Model, Model> createTransformer(List<String> arguments) {
        Pair<Set<ShapeId>, Set<String>> namesAndNamespaces = this.parseTraits(arguments);
        Set names = (Set)namesAndNamespaces.getLeft();
        Set namespaces = (Set)namesAndNamespaces.getRight();
        LOGGER.info(() -> "Including traits by ID " + names + " and namespaces " + namespaces);
        names.add(TraitDefinition.ID);
        return (transformer, model) -> {
            Set removeTraits = model.getTraitShapes().stream().filter(trait -> !this.matchesTraitDefinition((Shape)trait, names, namespaces)).collect(Collectors.toSet());
            if (!removeTraits.isEmpty()) {
                LOGGER.info(() -> "Removing traits that are not explicitly allowed: " + removeTraits);
            }
            return transformer.removeShapes(model, removeTraits);
        };
    }
}

