/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.model;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import software.amazon.smithy.build.SmithyBuildException;
import software.amazon.smithy.build.model.ProjectionConfig;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.build.model.TransformConfig;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.ModelSyntaxException;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.utils.IoUtils;
import software.amazon.smithy.utils.Pair;

final class ConfigLoader {
    private static final String VERSION = "1.0";
    private static final String VERSION_KEY = "version";
    private static final String IMPORTS_KEY = "imports";
    private static final String OUTPUT_DIRECTORY_KEY = "outputDirectory";
    private static final String PROJECTIONS_KEY = "projections";
    private static final String PLUGINS_KEY = "plugins";
    private static final String ABSTRACT_KEY = "abstract";
    private static final String FILTERS_KEY = "filters";
    private static final String MAPPERS_KEY = "mappers";
    private static final String TRANSFORMS_KEY = "transforms";
    private static final String NAME_KEY = "name";
    private static final String ARGS_KEY = "args";
    private static final List<String> ROOT_KEYS = Arrays.asList("version", "imports", "outputDirectory", "projections", "plugins");
    private static final List<String> PROJECTION_KEYS = Arrays.asList("abstract", "filters", "mappers", "transforms", "imports", "plugins");
    private static final List<String> TRANSFORM_KEYS = Arrays.asList("name", "args");

    private ConfigLoader() {
    }

    static SmithyBuildConfig load(Path path) {
        try {
            String content = IoUtils.readUtf8File((Path)path);
            return ConfigLoader.load(ConfigLoader.loadWithJson(path, content).expectObjectNode());
        }
        catch (ModelSyntaxException e) {
            throw new SmithyBuildException(e);
        }
    }

    private static Node loadWithJson(Path path, String contents) {
        return (Node)Node.parseJsonWithComments((String)contents, (String)path.toString()).accept((NodeVisitor)new VariableExpander());
    }

    private static SmithyBuildConfig load(ObjectNode node) {
        SmithyBuildConfig.Builder builder = SmithyBuildConfig.builder();
        node.warnIfAdditionalProperties(ROOT_KEYS);
        node.expectMember(VERSION_KEY).expectStringNode().expectOneOf(new String[]{VERSION});
        builder.imports(node.getArrayMember(IMPORTS_KEY).map(imports -> Node.loadArrayOfString((String)IMPORTS_KEY, (Node)imports)).orElse(Collections.emptyList()));
        node.getStringMember(OUTPUT_DIRECTORY_KEY).map(StringNode::getValue).ifPresent(builder::outputDirectory);
        builder.projections(node.getObjectMember(PROJECTIONS_KEY).map(ConfigLoader::loadProjections).orElse(Collections.emptyMap()));
        builder.plugins(node.getObjectMember(PLUGINS_KEY).map(ConfigLoader::loadPlugins).orElse(Collections.emptyMap()));
        return builder.build();
    }

    private static Map<String, ProjectionConfig> loadProjections(ObjectNode container) {
        return container.getMembers().entrySet().stream().map(entry -> Pair.of((Object)((StringNode)entry.getKey()).getValue(), (Object)ConfigLoader.loadProjection(((Node)entry.getValue()).expectObjectNode()))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    private static ProjectionConfig loadProjection(ObjectNode members) {
        members.warnIfAdditionalProperties(PROJECTION_KEYS);
        ProjectionConfig.Builder builder = ProjectionConfig.builder().isAbstract(members.getBooleanMemberOrDefault(ABSTRACT_KEY));
        builder.transforms(members.getArrayMember(TRANSFORMS_KEY).map(ConfigLoader::loadTransforms).orElse(Collections.emptyList()));
        builder.imports(members.getArrayMember(IMPORTS_KEY).map(imports -> Node.loadArrayOfString((String)IMPORTS_KEY, (Node)imports)).orElse(Collections.emptyList()));
        builder.plugins(members.getObjectMember(PLUGINS_KEY).map(ConfigLoader::loadPlugins).orElse(Collections.emptyMap()));
        return builder.build();
    }

    private static List<TransformConfig> loadTransforms(ArrayNode node) {
        return node.getElements().stream().map(element -> {
            ObjectNode objectNode = element.expectObjectNode();
            objectNode.warnIfAdditionalProperties(TRANSFORM_KEYS);
            String name = objectNode.expectMember(NAME_KEY).expectStringNode().getValue();
            List args = objectNode.getArrayMember(ARGS_KEY).map(argsNode -> argsNode.getElementsAs(StringNode::getValue)).orElseGet(Collections::emptyList);
            return TransformConfig.builder().name(name).args(args).build();
        }).collect(Collectors.toList());
    }

    private static Map<String, ObjectNode> loadPlugins(ObjectNode container) {
        return container.getMembers().entrySet().stream().map(entry -> Pair.of((Object)((StringNode)entry.getKey()).getValue(), (Object)((Node)entry.getValue()).expectObjectNode())).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    private static final class VariableExpander
    extends NodeVisitor.Default<Node> {
        private static final Pattern INLINE = Pattern.compile("(?:^|[^\\\\])\\$\\{(.+)}");
        private static final Pattern ESCAPED_INLINE = Pattern.compile("\\\\\\$");

        private VariableExpander() {
        }

        protected Node getDefault(Node node) {
            return node;
        }

        public Node arrayNode(ArrayNode node) {
            return (Node)node.getElements().stream().map(element -> (Node)element.accept((NodeVisitor)this)).collect(ArrayNode.collect());
        }

        public Node objectNode(ObjectNode node) {
            return (Node)node.getMembers().entrySet().stream().map(entry -> Pair.of((Object)((Node)((StringNode)entry.getKey()).accept((NodeVisitor)this)), (Object)((Node)((Node)entry.getValue()).accept((NodeVisitor)this)))).collect(ObjectNode.collect(pair -> ((Node)pair.getLeft()).expectStringNode(), Pair::getRight));
        }

        public Node stringNode(StringNode node) {
            Matcher matcher = INLINE.matcher(node.getValue());
            StringBuffer builder = new StringBuffer();
            while (matcher.find()) {
                String variable = matcher.group(1);
                String replacement = VariableExpander.expand(node.getSourceLocation(), variable);
                matcher.appendReplacement(builder, replacement);
            }
            matcher.appendTail(builder);
            String result = ESCAPED_INLINE.matcher(builder.toString()).replaceAll("\\$");
            return new StringNode(result, node.getSourceLocation());
        }

        private static String expand(SourceLocation sourceLocation, String variable) {
            String replacement = Optional.ofNullable(System.getProperty(variable)).orElseGet(() -> System.getenv(variable));
            if (replacement == null) {
                throw new SmithyBuildException(String.format("Unable to expand variable `" + variable + "` to an environment variable or system property: %s", sourceLocation));
            }
            return replacement;
        }
    }
}

