/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import software.amazon.smithy.build.ProjectionTransformer;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.transform.ModelTransformer;

public final class IncludeServices
implements ProjectionTransformer {
    @Override
    public String getName() {
        return "includeServices";
    }

    @Override
    public BiFunction<ModelTransformer, Model, Model> createTransformer(List<String> arguments) {
        Set includeServices = arguments.stream().map(ShapeId::from).collect(Collectors.toSet());
        return (transformer, model) -> transformer.filterShapes(model, shape -> !shape.isServiceShape() || includeServices.contains(shape.getId()));
    }
}

