/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.aws.traits.ArnIndex;
import software.amazon.smithy.aws.traits.ArnTrait;
import software.amazon.smithy.aws.traits.ServiceTrait;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class ArnTemplateValidator
extends AbstractValidator {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("^[!|+]?[a-zA-Z_][a-zA-Z0-9_]*$");

    public List<ValidationEvent> validate(Model model) {
        ArnIndex arnIndex = ArnIndex.of(model);
        return model.shapes(ServiceShape.class).flatMap(service -> Trait.flatMapStream((Shape)service, ServiceTrait.class)).flatMap(pair -> this.validateService(model, arnIndex, (ServiceShape)pair.getLeft())).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> validateService(Model model, ArnIndex arnIndex, ServiceShape service) {
        return arnIndex.getServiceResourceArns((ToShapeId)service.getId()).entrySet().stream().flatMap(entry -> OptionalUtils.stream(model.getShape((ShapeId)entry.getKey()).flatMap(Shape::asResourceShape).map(resource -> Pair.of((Object)resource, entry.getValue())))).flatMap(pair -> this.validateResourceArn((ResourceShape)pair.getLeft(), (ArnTrait)((Object)((Object)pair.getRight()))));
    }

    private Stream<ValidationEvent> validateResourceArn(ResourceShape resource, ArnTrait template) {
        return this.syntax((Shape)resource, template).map(Stream::of).orElseGet(() -> Stream.concat(OptionalUtils.stream(this.enough(resource.getIdentifiers().keySet(), (Shape)resource, template)), OptionalUtils.stream(this.tooMuch(resource.getIdentifiers().keySet(), (Shape)resource, template))));
    }

    private Optional<ValidationEvent> syntax(Shape shape, ArnTrait trait) {
        List invalid = trait.getLabels().stream().filter(expr -> !EXPRESSION_PATTERN.matcher((CharSequence)expr).find()).collect(Collectors.toList());
        if (invalid.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.error(shape, (FromSourceLocation)trait, String.format("aws.api#arn trait contains invalid template labels: %s. Template labels must match the following regular expression: %s", ValidationUtils.tickedList(invalid), EXPRESSION_PATTERN.pattern())));
    }

    private Optional<ValidationEvent> tooMuch(Collection<String> names, Shape shape, ArnTrait trait) {
        HashSet<String> templateCheck = new HashSet<String>(trait.getLabels());
        templateCheck.removeAll(names);
        if (!templateCheck.isEmpty()) {
            return Optional.of(this.error(shape, (FromSourceLocation)trait, String.format("Invalid aws.api#arn trait resource, `%s`. Found template labels in the trait that are not the names of the identifiers of the resource: %s. Extraneous identifiers: [%s]", trait.getTemplate(), names, ValidationUtils.tickedList(templateCheck))));
        }
        return Optional.empty();
    }

    private Optional<ValidationEvent> enough(Collection<String> names, Shape shape, ArnTrait trait) {
        HashSet<String> identifierVars = new HashSet<String>(names);
        identifierVars.removeAll(trait.getLabels());
        if (!identifierVars.isEmpty()) {
            return Optional.of(this.error(shape, (FromSourceLocation)trait, String.format("Invalid aws.api#arn trait resource, `%s`. The following resource identifier names were missing from the `arn` template: %s", trait.getTemplate(), ValidationUtils.tickedList(identifierVars))));
        }
        return Optional.empty();
    }
}

