/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import software.amazon.smithy.aws.traits.ServiceTrait;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class CloudWatchNamespaceValidator
extends AbstractValidator {
    private static final Pattern PASCAL_CASE_PATTERN = Pattern.compile("^[A-Z][a-zA-Z0-9]*(?:[A-Z][a-zA-Z0-9]*)*$");

    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ServiceShape service : model.getServiceShapesWithTrait(ServiceTrait.class)) {
            ServiceTrait trait = (ServiceTrait)service.expectTrait(ServiceTrait.class);
            Optional<String> cloudWatchNamespaceOpt = trait.getCloudWatchNamespace();
            if (!cloudWatchNamespaceOpt.isPresent()) continue;
            String cloudWatchNamespace = cloudWatchNamespaceOpt.get();
            boolean startsWithAws = cloudWatchNamespace.startsWith("AWS/");
            String prefixlessNamespace = cloudWatchNamespace.replace("AWS/", "");
            boolean isServicePascalCase = PASCAL_CASE_PATTERN.matcher(prefixlessNamespace).matches();
            if (startsWithAws && isServicePascalCase) continue;
            String message = "The service's CloudWatch metric namespace `%s` does not follow convention.";
            if (!startsWithAws) {
                message = message + " The namespace should start with the `AWS/` prefix.";
            }
            if (!isServicePascalCase) {
                message = message + " The namespace's service component `" + prefixlessNamespace + "` should be PascalCase.";
            }
            events.add(this.danger((Shape)service, (FromSourceLocation)trait, String.format(message, cloudWatchNamespace)));
        }
        return events;
    }
}

