/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.protocols;

import software.amazon.smithy.aws.traits.protocols.AwsProtocolTrait;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;

public final class RestXmlTrait
extends AwsProtocolTrait {
    public static final ShapeId ID = ShapeId.from((String)"aws.protocols#restXml");
    private final boolean noErrorWrapping;

    private RestXmlTrait(Builder builder) {
        super(ID, builder);
        this.noErrorWrapping = builder.noErrorWrapping;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isNoErrorWrapping() {
        return this.noErrorWrapping;
    }

    @Override
    protected Node createNode() {
        ObjectNode node = super.createNode().expectObjectNode();
        if (this.isNoErrorWrapping()) {
            node = node.withMember("noErrorWrapping", (ToNode)Node.from((boolean)this.noErrorWrapping));
        }
        return node;
    }

    public static final class Builder
    extends AwsProtocolTrait.Builder<RestXmlTrait, Builder> {
        private boolean noErrorWrapping = false;

        private Builder() {
        }

        public Builder noErrorWrapping(boolean noErrorWrapping) {
            this.noErrorWrapping = noErrorWrapping;
            return this;
        }

        @Override
        public Builder fromNode(Node node) {
            Builder builder = (Builder)((Object)super.fromNode(node));
            ObjectNode objectNode = node.expectObjectNode();
            builder.noErrorWrapping(objectNode.getBooleanMemberOrDefault("noErrorWrapping"));
            return builder;
        }

        public RestXmlTrait build() {
            return new RestXmlTrait(this);
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public RestXmlTrait createTrait(ShapeId target, Node value) {
            RestXmlTrait result = RestXmlTrait.builder().fromNode(value).build();
            result.setNodeCache(value);
            return result;
        }
    }
}

