/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.protocols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import software.amazon.smithy.aws.traits.protocols.AwsQueryCompatibleTrait;
import software.amazon.smithy.aws.traits.protocols.AwsQueryErrorTrait;
import software.amazon.smithy.aws.traits.protocols.AwsQueryTrait;
import software.amazon.smithy.aws.traits.protocols.Ec2QueryTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class QueryErrorCodeValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        List<ValidationEvent> events = Collections.emptyList();
        for (ServiceShape service : model.getServiceShapes()) {
            List<ValidationEvent> serviceEvents;
            if (!service.hasTrait(AwsQueryCompatibleTrait.class) && !service.hasTrait(AwsQueryTrait.class) && !service.hasTrait(Ec2QueryTrait.class) || (serviceEvents = this.validateService(model, service)).isEmpty()) continue;
            if (events.isEmpty()) {
                events = new ArrayList<ValidationEvent>();
            }
            events.addAll(serviceEvents);
        }
        return events;
    }

    private List<ValidationEvent> validateService(Model model, ServiceShape service) {
        TopDownIndex index = TopDownIndex.of((Model)model);
        HashSet errors = new HashSet(service.getErrorsSet());
        for (Object operation : index.getContainedOperations((ToShapeId)service)) {
            errors.addAll(operation.getErrorsSet());
        }
        HashMap<String, Set> errorCodeBindings = new HashMap<String, Set>();
        for (ShapeId errorId : errors) {
            String errorCode = errorId.getName();
            Shape errorShape = model.expectShape(errorId);
            if (errorShape.hasTrait(AwsQueryErrorTrait.class)) {
                AwsQueryErrorTrait trait = (AwsQueryErrorTrait)errorShape.expectTrait(AwsQueryErrorTrait.class);
                errorCode = trait.getCode();
            }
            errorCodeBindings.computeIfAbsent(errorCode, k -> new TreeSet()).add(errorId.toString());
        }
        List<ValidationEvent> events = Collections.emptyList();
        for (Map.Entry entry : errorCodeBindings.entrySet()) {
            if (((Set)entry.getValue()).size() == 1) continue;
            String errorCode = (String)entry.getKey();
            String shapes = String.join((CharSequence)", ", (Iterable)entry.getValue());
            if (events.isEmpty()) {
                events = new ArrayList<ValidationEvent>();
            }
            events.add(this.danger((Shape)service, String.format("Multiple error shapes with the error code `%s` found: [%s]. This error code ambiguity will result in the wrong error shape being deserialized when running the query protocol. This pain will be carried forward when migrating to a new protocol when using the awsQueryCompatible trait.", errorCode, shapes)));
        }
        return events;
    }
}

