/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.protocols;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.traits.protocols.AwsQueryCompatibleTrait;
import software.amazon.smithy.aws.traits.protocols.AwsQueryErrorTrait;
import software.amazon.smithy.aws.traits.protocols.AwsQueryTrait;
import software.amazon.smithy.aws.traits.protocols.Ec2QueryTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class QueryErrorCodeValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ServiceShape service : model.getServiceShapes()) {
            if (!service.hasTrait(AwsQueryCompatibleTrait.class) && !service.hasTrait(AwsQueryTrait.class) && !service.hasTrait(Ec2QueryTrait.class)) continue;
            events.addAll(this.validateService(model, service));
        }
        return events;
    }

    private List<ValidationEvent> validateService(Model model, ServiceShape service) {
        String errorCode;
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        TopDownIndex index = TopDownIndex.of((Model)model);
        ArrayList errors = new ArrayList(service.getErrors());
        index.getContainedOperations((ToShapeId)service).forEach(operation -> errors.addAll(operation.getErrors()));
        HashMap<String, Set> errorCodeBindings = new HashMap<String, Set>();
        for (ShapeId shapeId : errors) {
            errorCode = shapeId.getName();
            Shape errorShape = model.expectShape(shapeId);
            if (errorShape.hasTrait(AwsQueryErrorTrait.class)) {
                AwsQueryErrorTrait trait = (AwsQueryErrorTrait)errorShape.expectTrait(AwsQueryErrorTrait.class);
                errorCode = trait.getCode();
            }
            errorCodeBindings.computeIfAbsent(errorCode, k -> new TreeSet()).add(shapeId);
        }
        for (Map.Entry entry : errorCodeBindings.entrySet()) {
            if (((Set)entry.getValue()).size() == 1) continue;
            errorCode = (String)entry.getKey();
            String shapes = ((Set)entry.getValue()).stream().map(Objects::toString).collect(Collectors.joining(", "));
            events.add(this.danger((Shape)service, String.format("Multiple error shapes with the error code `%s` found: [%s]. This error code ambiguity will result in the wrong error shape being deserialized when running the query protocol. This pain will be carried forward when migrating to a new protocol when using the awsQueryCompatible trait.", errorCode, shapes)));
        }
        return events;
    }
}

