/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.tagging;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.aws.traits.tagging.AwsTagIndex;
import software.amazon.smithy.aws.traits.tagging.TagEnabledTrait;
import software.amazon.smithy.aws.traits.tagging.TaggableTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class TagEnabledServiceValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        TopDownIndex topDownIndex = TopDownIndex.of((Model)model);
        AwsTagIndex tagIndex = AwsTagIndex.of(model);
        for (ServiceShape service : model.getServiceShapesWithTrait(TagEnabledTrait.class)) {
            events.addAll(this.validateService(service, tagIndex, topDownIndex));
        }
        return events;
    }

    private List<ValidationEvent> validateService(ServiceShape service, AwsTagIndex tagIndex, TopDownIndex topDownIndex) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        TagEnabledTrait trait = (TagEnabledTrait)service.expectTrait(TagEnabledTrait.class);
        int taggableResourceCount = 0;
        for (ResourceShape resource : topDownIndex.getContainedResources((ToShapeId)service)) {
            if (!resource.hasTrait(TaggableTrait.class)) continue;
            ++taggableResourceCount;
        }
        if (taggableResourceCount == 0) {
            events.add(this.error((Shape)service, "Service marked `aws.api#tagEnabled` trait must have at least one `aws.api#taggable` resource."));
        }
        if (!trait.getDisableDefaultOperations() && !tagIndex.serviceHasTagApis((ToShapeId)service.getId())) {
            events.add(this.warning((Shape)service, "Service marked `aws.api#tagEnabled` trait does not have consistent tagging operations implemented: {TagResource, UntagResource, and ListTagsForResource}."));
        }
        return events;
    }
}

