/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.tagging;

import java.util.Optional;
import software.amazon.smithy.aws.traits.tagging.TaggableApiConfig;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class TaggableTrait
extends AbstractTrait
implements ToSmithyBuilder<TaggableTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.api#taggable");
    private final String property;
    private final TaggableApiConfig apiConfig;
    private final boolean disableSystemTags;

    private TaggableTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.property = builder.property;
        this.apiConfig = builder.apiConfig;
        this.disableSystemTags = builder.disableSystemTags;
    }

    public boolean getDisableSystemTags() {
        return this.disableSystemTags;
    }

    public Optional<TaggableApiConfig> getApiConfig() {
        return Optional.ofNullable(this.apiConfig);
    }

    public Optional<String> getProperty() {
        return Optional.ofNullable(this.property);
    }

    protected Node createNode() {
        return new ObjectNode(MapUtils.of(), this.getSourceLocation()).withOptionalMember("property", this.getProperty().map(Node::from)).withOptionalMember("apiConfig", this.getApiConfig().map(TaggableApiConfig::toNode)).withMember("disableSystemTags", this.getDisableSystemTags());
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return (Builder)TaggableTrait.builder().property(this.property).apiConfig(this.apiConfig).disableSystemTags(this.disableSystemTags).sourceLocation((FromSourceLocation)this.getSourceLocation());
    }

    public static final class Builder
    extends AbstractTraitBuilder<TaggableTrait, Builder> {
        private String property;
        private TaggableApiConfig apiConfig;
        private boolean disableSystemTags = false;

        public Builder property(String property) {
            this.property = property;
            return this;
        }

        public Builder apiConfig(TaggableApiConfig apiConfig) {
            this.apiConfig = apiConfig;
            return this;
        }

        public Builder disableSystemTags(Boolean disableSystemTags) {
            this.disableSystemTags = disableSystemTags;
            return this;
        }

        public TaggableTrait build() {
            return new TaggableTrait(this);
        }
    }

    public static final class Provider
    implements TraitService {
        public ShapeId getShapeId() {
            return ID;
        }

        public TaggableTrait createTrait(ShapeId target, Node value) {
            Builder builder = TaggableTrait.builder();
            ObjectNode valueObjectNode = value.expectObjectNode();
            if (valueObjectNode.containsMember("property")) {
                builder.property(valueObjectNode.expectStringMember("property").getValue());
            }
            if (valueObjectNode.containsMember("disableSystemTags")) {
                builder.disableSystemTags(valueObjectNode.expectBooleanMember("disableSystemTags").getValue());
            }
            if (valueObjectNode.containsMember("apiConfig")) {
                TaggableApiConfig.Builder apiConfigBuilder = TaggableApiConfig.builder();
                apiConfigBuilder.tagApi(ShapeId.from((String)valueObjectNode.expectObjectMember("apiConfig").expectStringMember("tagApi").getValue()));
                apiConfigBuilder.untagApi(ShapeId.from((String)valueObjectNode.expectObjectMember("apiConfig").expectStringMember("untagApi").getValue()));
                apiConfigBuilder.listTagsApi(ShapeId.from((String)valueObjectNode.expectObjectMember("apiConfig").expectStringMember("listTagsApi").getValue()));
                builder.apiConfig(apiConfigBuilder.build());
            }
            TaggableTrait result = builder.build();
            result.setNodeCache(value);
            return result;
        }
    }
}

