/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.protocols;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.traits.protocols.AwsProtocolTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.knowledge.HttpBindingIndex;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class ProtocolHttpPayloadValidator
extends AbstractValidator {
    private static final Set<ShapeType> VALID_HTTP_PAYLOAD_TYPES = SetUtils.of((Object[])new ShapeType[]{ShapeType.STRUCTURE, ShapeType.UNION, ShapeType.DOCUMENT, ShapeType.BLOB, ShapeType.STRING, ShapeType.ENUM});

    public List<ValidationEvent> validate(Model model) {
        ServiceIndex serviceIndex = ServiceIndex.of((Model)model);
        HttpBindingIndex bindingIndex = HttpBindingIndex.of((Model)model);
        TopDownIndex topDownIndex = TopDownIndex.of((Model)model);
        return model.shapes(ServiceShape.class).filter(service -> this.usesAwsProtocol((ServiceShape)service, serviceIndex)).flatMap(service -> this.validateService(model, (ServiceShape)service, bindingIndex, topDownIndex).stream()).collect(Collectors.toList());
    }

    private boolean usesAwsProtocol(ServiceShape service, ServiceIndex index) {
        for (Trait protocol : index.getProtocols((ToShapeId)service).values()) {
            if (!(protocol instanceof AwsProtocolTrait)) continue;
            return true;
        }
        return false;
    }

    private List<ValidationEvent> validateService(Model model, ServiceShape service, HttpBindingIndex bindingIndex, TopDownIndex topDownIndex) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (OperationShape operation : topDownIndex.getContainedOperations((ToShapeId)service)) {
            List requestBindings = bindingIndex.getRequestBindings((ToShapeId)operation, HttpBinding.Location.PAYLOAD);
            this.validateBindings(model, requestBindings).ifPresent(events::add);
            List responseBindings = bindingIndex.getResponseBindings((ToShapeId)operation, HttpBinding.Location.PAYLOAD);
            this.validateBindings(model, responseBindings).ifPresent(events::add);
            for (ShapeId error : operation.getErrors()) {
                List errorBindings = bindingIndex.getResponseBindings((ToShapeId)error, HttpBinding.Location.PAYLOAD);
                this.validateBindings(model, errorBindings).ifPresent(events::add);
            }
        }
        return events;
    }

    private Optional<ValidationEvent> validateBindings(Model model, Collection<HttpBinding> payloadBindings) {
        for (HttpBinding binding : payloadBindings) {
            if (this.payloadBoundToValidType(model, (ToShapeId)binding.getMember().getTarget())) continue;
            return Optional.of(this.error((Shape)binding.getMember(), "AWS Protocols only support binding the following shape types to the payload: string, blob, structure, union, and document"));
        }
        return Optional.empty();
    }

    private boolean payloadBoundToValidType(Model model, ToShapeId payloadShape) {
        return model.getShape(payloadShape.toShapeId()).map(shape -> VALID_HTTP_PAYLOAD_TYPES.contains(shape.getType())).orElse(false);
    }
}

