/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.tagging;

import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import software.amazon.smithy.aws.traits.tagging.TaggableTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.PropertyBindingIndex;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;

final class TaggingShapeUtils {
    static final String TAG_RESOURCE_OPNAME = "TagResource";
    static final String UNTAG_RESOURCE_OPNAME = "UntagResource";
    static final String LIST_TAGS_OPNAME = "ListTagsForResource";
    private static final Pattern TAG_PROPERTY_REGEX = Pattern.compile("^[T|t]ag(s|[L|l]ist)$");
    private static final Pattern RESOURCE_ARN_REGEX = Pattern.compile("^([R|r]esource)?([A|a]rn|ARN)$");
    private static final Pattern TAG_KEYS_REGEX = Pattern.compile("^[T|t]ag[K|k]eys$");

    private TaggingShapeUtils() {
    }

    static String getDesiredTagsPropertyName() {
        return "[T|t]ags";
    }

    static String getDesiredArnName() {
        return "[R|r]esourceArn";
    }

    static String getDesiredTagKeysName() {
        return "[T|t]agKeys";
    }

    static boolean isTagDesiredName(String memberName) {
        return TAG_PROPERTY_REGEX.matcher(memberName).matches();
    }

    static boolean isArnMemberDesiredName(String memberName) {
        return RESOURCE_ARN_REGEX.matcher(memberName).matches();
    }

    static boolean isTagKeysDesiredName(String memberName) {
        return TAG_KEYS_REGEX.matcher(memberName).matches();
    }

    static boolean hasResourceArnInput(Map<String, MemberShape> inputMembers, Model model) {
        for (Map.Entry<String, MemberShape> memberEntry : inputMembers.entrySet()) {
            if (!TaggingShapeUtils.isArnMemberDesiredName(memberEntry.getKey()) || !model.expectShape(memberEntry.getValue().getTarget()).isStringShape()) continue;
            return true;
        }
        return false;
    }

    static boolean verifyTagsShape(Model model, Shape tagShape) {
        return TaggingShapeUtils.verifyTagListShape(model, tagShape) || TaggingShapeUtils.verifyTagMapShape(model, tagShape);
    }

    static boolean verifyTagListShape(Model model, Shape tagShape) {
        StructureShape memberStructureShape;
        ListShape listShape;
        Shape listTargetShape;
        if (tagShape.isListShape() && (listTargetShape = model.expectShape((listShape = (ListShape)tagShape.asListShape().get()).getMember().getTarget())).isStructureShape() && (memberStructureShape = (StructureShape)listTargetShape.asStructureShape().get()).members().size() == 2) {
            boolean allStrings = true;
            for (MemberShape member : memberStructureShape.members()) {
                allStrings &= model.expectShape(member.getTarget()).isStringShape();
            }
            return allStrings;
        }
        return false;
    }

    static boolean verifyTagMapShape(Model model, Shape tagShape) {
        if (tagShape.isMapShape()) {
            MapShape mapShape = (MapShape)tagShape.asMapShape().get();
            Shape valueTargetShape = model.expectShape(mapShape.getValue().getTarget());
            return valueTargetShape.isStringShape();
        }
        return false;
    }

    static boolean verifyTagKeysShape(Model model, Shape tagShape) {
        return tagShape.isListShape() && model.expectShape(((ListShape)tagShape.asListShape().get()).getMember().getTarget()).isStringShape();
    }

    static boolean verifyTagResourceOperation(Model model, OperationShape tagResourceOperation, OperationIndex operationIndex) {
        Map inputMembers = operationIndex.getInputMembers((ToShapeId)tagResourceOperation);
        int taglistMemberCount = 0;
        for (Map.Entry memberEntry : inputMembers.entrySet()) {
            if (!TaggingShapeUtils.isTagDesiredName((String)memberEntry.getKey()) || !TaggingShapeUtils.verifyTagsShape(model, model.expectShape(((MemberShape)memberEntry.getValue()).getTarget()))) continue;
            ++taglistMemberCount;
        }
        return taglistMemberCount == 1 && TaggingShapeUtils.hasResourceArnInput(inputMembers, model);
    }

    static boolean verifyUntagResourceOperation(Model model, OperationShape untagResourceOperation, OperationIndex operationIndex) {
        Map inputMembers = operationIndex.getInputMembers((ToShapeId)untagResourceOperation);
        int untagKeyMemberCount = 0;
        for (Map.Entry memberEntry : inputMembers.entrySet()) {
            if (!TaggingShapeUtils.isTagKeysDesiredName((String)memberEntry.getKey()) || !TaggingShapeUtils.verifyTagKeysShape(model, model.expectShape(((MemberShape)memberEntry.getValue()).getTarget()))) continue;
            ++untagKeyMemberCount;
        }
        return untagKeyMemberCount == 1 && TaggingShapeUtils.hasResourceArnInput(inputMembers, model);
    }

    static boolean verifyListTagsOperation(Model model, OperationShape listTagsResourceOperation, OperationIndex operationIndex) {
        Map inputMembers = operationIndex.getInputMembers((ToShapeId)listTagsResourceOperation);
        Map outputMembers = operationIndex.getOutputMembers((ToShapeId)listTagsResourceOperation);
        int taglistMemberCount = 0;
        for (Map.Entry memberEntry : outputMembers.entrySet()) {
            if (!TaggingShapeUtils.isTagDesiredName((String)memberEntry.getKey()) || !TaggingShapeUtils.verifyTagsShape(model, model.expectShape(((MemberShape)memberEntry.getValue()).getTarget()))) continue;
            ++taglistMemberCount;
        }
        return taglistMemberCount == 1 && TaggingShapeUtils.hasResourceArnInput(inputMembers, model);
    }

    static boolean isTagPropertyInInput(Optional<ShapeId> operationId, Model model, ResourceShape resource) {
        PropertyBindingIndex propertyBindingIndex = PropertyBindingIndex.of((Model)model);
        Optional<String> property = ((TaggableTrait)resource.expectTrait(TaggableTrait.class)).getProperty();
        if (property.isPresent() && operationId.isPresent()) {
            OperationShape operation = (OperationShape)model.expectShape(operationId.get()).asOperationShape().get();
            Shape inputShape = model.expectShape(operation.getInputShape());
            return TaggingShapeUtils.isTagPropertyInShape(property.get(), inputShape, propertyBindingIndex);
        }
        return false;
    }

    static boolean isTagPropertyInShape(String tagPropertyName, Shape shape, PropertyBindingIndex propertyBindingIndex) {
        for (MemberShape member : shape.members()) {
            Optional propertyName = propertyBindingIndex.getPropertyName(member.getId());
            if (!propertyName.isPresent() || !((String)propertyName.get()).equals(tagPropertyName)) continue;
            return true;
        }
        return false;
    }
}

