/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.clientendpointdiscovery;

import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ClientEndpointDiscoveryTrait
extends AbstractTrait
implements ToSmithyBuilder<ClientEndpointDiscoveryTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.api#clientEndpointDiscovery");
    private static final String OPERATION = "operation";
    private static final String ERROR = "error";
    private final ShapeId operation;
    private final ShapeId error;

    public ClientEndpointDiscoveryTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.operation = builder.operation;
        this.error = builder.error;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ShapeId getOperation() {
        return this.operation;
    }

    public Optional<ShapeId> getOptionalError() {
        return Optional.ofNullable(this.error);
    }

    @Deprecated
    public ShapeId getError() {
        return this.error;
    }

    protected Node createNode() {
        return Node.objectNodeBuilder().sourceLocation(this.getSourceLocation()).withMember(OPERATION, (ToNode)Node.from((String)this.getOperation().toString())).withOptionalMember(ERROR, this.getOptionalError().map(error -> Node.from((String)error.toString()))).build();
    }

    public Builder toBuilder() {
        return ((Builder)new Builder().sourceLocation((FromSourceLocation)this.getSourceLocation())).operation(this.operation).error(this.error);
    }

    public static final class Builder
    extends AbstractTraitBuilder<ClientEndpointDiscoveryTrait, Builder> {
        private ShapeId operation;
        private ShapeId error;

        private Builder() {
        }

        public ClientEndpointDiscoveryTrait build() {
            return new ClientEndpointDiscoveryTrait(this);
        }

        public Builder operation(ShapeId operation) {
            this.operation = operation;
            return this;
        }

        public Builder error(ShapeId error) {
            this.error = error;
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public ClientEndpointDiscoveryTrait createTrait(ShapeId target, Node value) {
            ObjectNode objectNode = value.expectObjectNode();
            Builder builder = ((Builder)ClientEndpointDiscoveryTrait.builder().sourceLocation((FromSourceLocation)value)).operation(objectNode.expectStringMember(ClientEndpointDiscoveryTrait.OPERATION).expectShapeId());
            objectNode.getStringMember(ClientEndpointDiscoveryTrait.ERROR).ifPresent(error -> builder.error(error.expectShapeId()));
            ClientEndpointDiscoveryTrait result = builder.build();
            result.setNodeCache((Node)objectNode);
            return result;
        }
    }
}

