/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.tagging;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.aws.traits.tagging.TagEnabledTrait;
import software.amazon.smithy.aws.traits.tagging.TaggableTrait;
import software.amazon.smithy.aws.traits.tagging.TaggingShapeUtils;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.PropertyBindingIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.SmithyInternalApi;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class AwsTagIndex
implements KnowledgeIndex {
    private final Set<ShapeId> servicesWithAllTagOperations = new HashSet<ShapeId>();
    private final Set<ShapeId> resourceIsTagOnCreate = new HashSet<ShapeId>();
    private final Set<ShapeId> resourceIsTagOnUpdate = new HashSet<ShapeId>();
    private final Map<ShapeId, ShapeId> shapeToTagOperation = new HashMap<ShapeId, ShapeId>();
    private final Set<ShapeId> serviceTagOperationIsValid = new HashSet<ShapeId>();
    private final Map<ShapeId, ShapeId> shapeToUntagOperation = new HashMap<ShapeId, ShapeId>();
    private final Set<ShapeId> serviceUntagOperationIsValid = new HashSet<ShapeId>();
    private final Map<ShapeId, ShapeId> shapeToListTagsOperation = new HashMap<ShapeId, ShapeId>();
    private final Set<ShapeId> serviceListTagsOperationIsValid = new HashSet<ShapeId>();

    private AwsTagIndex(Model model) {
        PropertyBindingIndex propertyBindingIndex = PropertyBindingIndex.of((Model)model);
        OperationIndex operationIndex = OperationIndex.of((Model)model);
        for (ServiceShape service : model.getServiceShapesWithTrait(TagEnabledTrait.class)) {
            for (ShapeId resourceId : service.getResources()) {
                ResourceShape resource = (ResourceShape)model.expectShape(resourceId, ResourceShape.class);
                if (!resource.hasTrait(TaggableTrait.class) || !((TaggableTrait)resource.expectTrait(TaggableTrait.class)).getProperty().isPresent()) continue;
                if (TaggingShapeUtils.isTagPropertyInInput(resource.getCreate(), model, resource, propertyBindingIndex)) {
                    this.resourceIsTagOnCreate.add(resourceId);
                }
                if (!TaggingShapeUtils.isTagPropertyInInput(resource.getUpdate(), model, resource, propertyBindingIndex)) continue;
                this.resourceIsTagOnUpdate.add(resourceId);
            }
            if (!this.verifyTagApis(model, service, operationIndex)) continue;
            this.servicesWithAllTagOperations.add(service.getId());
        }
    }

    public static AwsTagIndex of(Model model) {
        return new AwsTagIndex(model);
    }

    public boolean isResourceTagOnCreate(ShapeId resourceId) {
        return this.resourceIsTagOnCreate.contains(resourceId);
    }

    public boolean isResourceTagOnUpdate(ShapeId resourceId) {
        return this.resourceIsTagOnUpdate.contains(resourceId);
    }

    public boolean serviceHasTagApis(ShapeId serviceShapeId) {
        return this.servicesWithAllTagOperations.contains(serviceShapeId);
    }

    public Optional<ShapeId> getTagResourceOperation(ShapeId serviceOrResourceId) {
        return Optional.ofNullable(this.shapeToTagOperation.get(serviceOrResourceId));
    }

    public Optional<ShapeId> getUntagResourceOperation(ShapeId serviceOrResourceId) {
        return Optional.ofNullable(this.shapeToUntagOperation.get(serviceOrResourceId));
    }

    public Optional<ShapeId> getListTagsForResourceOperation(ShapeId serviceOrResourceId) {
        return Optional.ofNullable(this.shapeToListTagsOperation.get(serviceOrResourceId));
    }

    public boolean serviceHasValidTagResourceOperation(ShapeId serviceId) {
        return this.serviceTagOperationIsValid.contains(serviceId);
    }

    public boolean serviceHasValidUntagResourceOperation(ShapeId serviceId) {
        return this.serviceUntagOperationIsValid.contains(serviceId);
    }

    public boolean serviceHasValidListTagsForResourceOperation(ShapeId serviceId) {
        return this.serviceListTagsOperationIsValid.contains(serviceId);
    }

    private boolean verifyTagApis(Model model, ServiceShape service, OperationIndex operationIndex) {
        boolean hasTagApi = false;
        boolean hasUntagApi = false;
        boolean hasListTagsApi = false;
        LinkedList serviceResources = new LinkedList();
        TopDownIndex topDownIndex = TopDownIndex.of((Model)model);
        topDownIndex.getContainedResources((ToShapeId)service).forEach(resource -> serviceResources.add(resource.getId()));
        HashMap<String, ShapeId> operationMap = new HashMap<String, ShapeId>();
        for (ShapeId operationId : service.getOperations()) {
            operationMap.put(operationId.getName(), operationId);
        }
        if (operationMap.containsKey("TagResource")) {
            ShapeId tagOperationId = (ShapeId)operationMap.get("TagResource");
            this.shapeToTagOperation.put(service.getId(), tagOperationId);
            serviceResources.forEach(resourceId -> this.shapeToTagOperation.put((ShapeId)resourceId, tagOperationId));
            OperationShape tagOperation = (OperationShape)model.expectShape(tagOperationId, OperationShape.class);
            hasTagApi = TaggingShapeUtils.verifyTagResourceOperation(model, service, tagOperation, operationIndex);
            if (hasTagApi) {
                this.serviceTagOperationIsValid.add(service.getId());
            }
        }
        if (operationMap.containsKey("UntagResource")) {
            ShapeId untagOperationId = (ShapeId)operationMap.get("UntagResource");
            this.shapeToUntagOperation.put(service.getId(), untagOperationId);
            serviceResources.forEach(resourceId -> this.shapeToUntagOperation.put((ShapeId)resourceId, untagOperationId));
            OperationShape untagOperation = (OperationShape)model.expectShape(untagOperationId, OperationShape.class);
            hasUntagApi = TaggingShapeUtils.verifyUntagResourceOperation(model, service, untagOperation, operationIndex);
            if (hasUntagApi) {
                this.serviceUntagOperationIsValid.add(service.getId());
            }
        }
        if (operationMap.containsKey("ListTagsForResource")) {
            ShapeId listTagsOperationId = (ShapeId)operationMap.get("ListTagsForResource");
            this.shapeToListTagsOperation.put(service.getId(), listTagsOperationId);
            serviceResources.forEach(resourceId -> this.shapeToListTagsOperation.put((ShapeId)resourceId, listTagsOperationId));
            OperationShape listTagsOperation = (OperationShape)model.expectShape(listTagsOperationId, OperationShape.class);
            hasListTagsApi = TaggingShapeUtils.verifyListTagsOperation(model, service, listTagsOperation, operationIndex);
            if (hasListTagsApi) {
                this.serviceListTagsOperationIsValid.add(service.getId());
            }
        }
        return hasTagApi && hasUntagApi && hasListTagsApi;
    }

    @SmithyInternalApi
    public static Optional<MemberShape> getTagsMember(Model model, OperationShape tagResourceOperation) {
        for (MemberShape memberShape : ((StructureShape)model.expectShape(tagResourceOperation.getInputShape(), StructureShape.class)).members()) {
            if (!TaggingShapeUtils.isTagDesiredName(memberShape.getMemberName())) continue;
            return Optional.of(memberShape);
        }
        return Optional.empty();
    }
}

