/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.aws.traits.ServiceTrait;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyInternalApi;
import software.amazon.smithy.utils.StringUtils;

@SmithyInternalApi
public final class EventSourceValidator
extends AbstractValidator {
    private static final Map<String, String> KNOWN_EXCEPTIONS = MapUtils.of((Object)"cloudwatch.amazonaws.com", (Object)"monitoring.amazonaws.com");

    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ServiceShape service : model.getServiceShapesWithTrait(ServiceTrait.class)) {
            this.validateService(service, (ServiceTrait)service.expectTrait(ServiceTrait.class)).ifPresent(events::add);
        }
        return events;
    }

    private Optional<ValidationEvent> validateService(ServiceShape service, ServiceTrait trait) {
        String message = null;
        String source = trait.getCloudTrailEventSource();
        String expectedEventSource = trait.getArnNamespace() + ".amazonaws.com";
        if (!Objects.equals(KNOWN_EXCEPTIONS.get(expectedEventSource), source)) {
            if (source.contains("REPLACE") || StringUtils.upperCase((String)source).equals(source)) {
                message = "aws.api#service|cloudTrailEventSource must not use placeholders, but found: " + source;
            } else if (!source.equals(expectedEventSource)) {
                message = String.format("aws.api#service|cloudTrailEventSource does not match the expected value. Expected '%s', but found '%s'.", expectedEventSource, source);
            }
        }
        return message == null ? Optional.empty() : Optional.of(this.warning((Shape)service, (FromSourceLocation)trait, message));
    }
}

