/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ServiceTrait
extends AbstractTrait
implements ToSmithyBuilder<ServiceTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.api#service");
    private static final Logger LOGGER = Logger.getLogger(ServiceTrait.class.getName());
    private final String cloudFormationName;
    private final String arnNamespace;
    private final String sdkId;
    private final String cloudTrailEventSource;
    private final String docId;
    private final String endpointPrefix;

    private ServiceTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.sdkId = (String)SmithyBuilder.requiredState((String)"sdkId", (Object)builder.sdkId);
        this.arnNamespace = (String)SmithyBuilder.requiredState((String)"arnNamespace", (Object)builder.arnNamespace);
        this.cloudFormationName = (String)SmithyBuilder.requiredState((String)"cloudFormationName", (Object)builder.cloudFormationName);
        this.cloudTrailEventSource = (String)SmithyBuilder.requiredState((String)"cloudTrailEventSource", (Object)builder.cloudTrailEventSource);
        this.docId = builder.docId;
        this.endpointPrefix = (String)SmithyBuilder.requiredState((String)"endpointPrefix", (Object)builder.endpointPrefix);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getArnNamespace() {
        return this.arnNamespace;
    }

    public String getCloudFormationName() {
        return this.cloudFormationName;
    }

    public String getSdkId() {
        return this.sdkId;
    }

    public String getCloudTrailEventSource() {
        return this.cloudTrailEventSource;
    }

    public String resolveDocId(ServiceShape serviceShape) {
        return this.getDocId().orElseGet(() -> this.buildDefaultDocId(serviceShape));
    }

    protected Optional<String> getDocId() {
        return Optional.ofNullable(this.docId);
    }

    private String buildDefaultDocId(ServiceShape serviceShape) {
        if (!((ServiceTrait)serviceShape.expectTrait(ServiceTrait.class)).equals((Object)this)) {
            throw new ExpectationNotMetException(String.format("Provided service shape `%s` is not the target of this trait.", serviceShape.getId()), (FromSourceLocation)this);
        }
        return this.sdkId.replace(" ", "-").toLowerCase(Locale.US) + "-" + serviceShape.getVersion();
    }

    public String getEndpointPrefix() {
        return this.endpointPrefix;
    }

    @Deprecated
    public Optional<String> getAbbreviation() {
        return Optional.empty();
    }

    public Builder toBuilder() {
        return ((Builder)new Builder().sdkId(this.sdkId).sourceLocation((FromSourceLocation)this.getSourceLocation())).cloudFormationName(this.cloudFormationName).arnNamespace(this.arnNamespace).cloudTrailEventSource(this.cloudTrailEventSource).docId(this.docId).endpointPrefix(this.endpointPrefix);
    }

    protected Node createNode() {
        return Node.objectNodeBuilder().sourceLocation(this.getSourceLocation()).withMember("sdkId", (ToNode)Node.from((String)this.sdkId)).withMember("arnNamespace", (ToNode)Node.from((String)this.getArnNamespace())).withMember("cloudFormationName", (ToNode)Node.from((String)this.getCloudFormationName())).withMember("cloudTrailEventSource", (ToNode)Node.from((String)this.getCloudTrailEventSource())).withOptionalMember("docId", this.getDocId().map(Node::from)).withMember("endpointPrefix", (ToNode)Node.from((String)this.getEndpointPrefix())).build();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ServiceTrait)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        ServiceTrait os = (ServiceTrait)((Object)other);
        return this.sdkId.equals(os.sdkId) && this.arnNamespace.equals(os.arnNamespace) && this.cloudFormationName.equals(os.cloudFormationName) && this.cloudTrailEventSource.equals(os.cloudTrailEventSource) && this.docId == null ? os.docId == null : this.docId.equals(os.docId) && this.endpointPrefix.equals(os.endpointPrefix);
    }

    public int hashCode() {
        return Objects.hash(this.toShapeId(), this.sdkId, this.arnNamespace, this.cloudFormationName, this.cloudTrailEventSource, this.docId, this.endpointPrefix);
    }

    public static final class Builder
    extends AbstractTraitBuilder<ServiceTrait, Builder> {
        private String sdkId;
        private String cloudFormationName;
        private String arnNamespace;
        private String cloudTrailEventSource;
        private String docId;
        private String endpointPrefix;

        private Builder() {
        }

        public ServiceTrait build() {
            if (this.endpointPrefix == null) {
                this.endpointPrefix(this.arnNamespace);
            }
            return new ServiceTrait(this);
        }

        public ServiceTrait build(ShapeId target) {
            if (this.arnNamespace == null) {
                this.arnNamespace(target.getName().toLowerCase(Locale.US));
            }
            if (this.cloudFormationName == null) {
                this.cloudFormationName(target.getName());
            }
            if (this.cloudTrailEventSource == null) {
                this.cloudTrailEventSource(this.arnNamespace + ".amazonaws.com");
            }
            if (this.endpointPrefix == null) {
                this.endpointPrefix(this.arnNamespace);
            }
            return new ServiceTrait(this);
        }

        public Builder cloudFormationName(String cloudFormationName) {
            this.cloudFormationName = cloudFormationName;
            return this;
        }

        public Builder arnNamespace(String arnNamespace) {
            this.arnNamespace = arnNamespace;
            return this;
        }

        public Builder sdkId(String sdkId) {
            this.sdkId = sdkId;
            return this;
        }

        public Builder cloudTrailEventSource(String cloudTrailEventSource) {
            this.cloudTrailEventSource = cloudTrailEventSource;
            return this;
        }

        public Builder docId(String docId) {
            this.docId = docId;
            return this;
        }

        public Builder endpointPrefix(String endpointPrefix) {
            this.endpointPrefix = endpointPrefix;
            return this;
        }

        @Deprecated
        public Builder abbreviation(String abbreviation) {
            LOGGER.warning("The `abbreviation` property of aws.api#service is not supported");
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            ObjectNode objectNode = value.expectObjectNode();
            Builder builder = (Builder)ServiceTrait.builder().sourceLocation((FromSourceLocation)value);
            String sdkId = objectNode.getStringMember("sdkId").map(StringNode::getValue).orElseThrow(() -> new SourceException(String.format("No sdkId was provided. Perhaps you could set this to %s?", target.getName()), (FromSourceLocation)value));
            builder.sdkId(sdkId);
            objectNode.getStringMember("arnNamespace").map(StringNode::getValue).ifPresent(builder::arnNamespace);
            objectNode.getStringMember("cloudFormationName").map(StringNode::getValue).ifPresent(builder::cloudFormationName);
            objectNode.getStringMember("cloudTrailEventSource").map(StringNode::getValue).ifPresent(builder::cloudTrailEventSource);
            objectNode.getStringMember("docId").map(StringNode::getValue).ifPresent(builder::docId);
            objectNode.getStringMember("endpointPrefix").map(StringNode::getValue).ifPresent(builder::endpointPrefix);
            ServiceTrait result = builder.build(target);
            result.setNodeCache(value);
            return result;
        }
    }
}

