/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.tagging;

import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class TagEnabledTrait
extends AbstractTrait
implements ToSmithyBuilder<TagEnabledTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.api#tagEnabled");
    private final boolean disableDefaultOperations;

    public TagEnabledTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.disableDefaultOperations = builder.disableDefaultOperations;
    }

    protected Node createNode() {
        return new ObjectNode(MapUtils.of(), this.getSourceLocation()).withMember("disableDefaultOperations", this.getDisableDefaultOperations());
    }

    public boolean getDisableDefaultOperations() {
        return this.disableDefaultOperations;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return TagEnabledTrait.builder().disableDefaultOperations(this.disableDefaultOperations);
    }

    public static final class Builder
    extends AbstractTraitBuilder<TagEnabledTrait, Builder> {
        private Boolean disableDefaultOperations = false;

        public Builder disableDefaultOperations(Boolean disableDefaultOperations) {
            this.disableDefaultOperations = disableDefaultOperations;
            return this;
        }

        public TagEnabledTrait build() {
            return new TagEnabledTrait(this);
        }
    }

    public static final class Provider
    implements TraitService {
        public ShapeId getShapeId() {
            return ID;
        }

        public TagEnabledTrait createTrait(ShapeId target, Node value) {
            ObjectNode objectNode = value.expectObjectNode();
            Boolean name = objectNode.getBooleanMemberOrDefault("disableDefaultOperations", Boolean.valueOf(false));
            TagEnabledTrait result = ((Builder)TagEnabledTrait.builder().sourceLocation((FromSourceLocation)value)).disableDefaultOperations(name).build();
            result.setNodeCache(value);
            return result;
        }
    }
}

