/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import software.amazon.smithy.aws.traits.ServiceTrait;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class SdkServiceIdValidator
extends AbstractValidator {
    private static final Set<String> COMPANY_NAMES = SetUtils.of((Object[])new String[]{"AWS", "Aws", "Amazon"});
    private static final Set<String> DISALLOWED_ENDINGS = SetUtils.of((Object[])new String[]{"service", "client", "api"});
    private static final Pattern SERVICE_ID_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9]*( [a-zA-Z0-9]+)*$");
    private static final Set<String> PREEXISTING_SERVICE_IDS = SetUtils.of((Object[])new String[]{"ACM PCA", "ApiGatewayManagementApi", "Config Service", "Cost and Usage Report Service", "Application Discovery Service", "Database Migration Service", "Directory Service", "Elasticsearch Service", "IoT 1Click Devices Service", "IoTAnalytics", "Lex Model Building Service", "Lex Runtime Service", "Marketplace Entitlement Service", "mq", "Resource Groups Tagging API"});

    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ServiceShape service : model.getServiceShapesWithTrait(ServiceTrait.class)) {
            this.validateService(service, (ServiceTrait)service.expectTrait(ServiceTrait.class)).ifPresent(events::add);
        }
        return events;
    }

    public static boolean isPreviouslyReleasedInvalidServiceId(String serviceId) {
        return PREEXISTING_SERVICE_IDS.contains(serviceId);
    }

    public static void validateServiceId(String serviceId) {
        if (SdkServiceIdValidator.isPreviouslyReleasedInvalidServiceId(serviceId)) {
            return;
        }
        ArrayList<String> messages = new ArrayList<String>();
        if (!SdkServiceIdValidator.validForPattern(serviceId)) {
            messages.add(String.format("Does not match the required pattern `%s`", SERVICE_ID_PATTERN.pattern()));
        }
        if (SdkServiceIdValidator.containsCompanyName(serviceId)) {
            messages.add(String.format("Must not contain any of the following company names: [%s]", ValidationUtils.tickedList(COMPANY_NAMES)));
        }
        SdkServiceIdValidator.endsWithForbiddenWord(serviceId).ifPresent(suffix -> messages.add(String.format("Must not case-insensitively end with `%s`", suffix)));
        if (serviceId.length() < 2 || serviceId.length() > 50) {
            messages.add("Must be between 2 and 50 characters long.");
        }
        if (!messages.isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid SDK service ID value, `%s`: %s", serviceId, String.join((CharSequence)";", messages)));
        }
    }

    private Optional<ValidationEvent> validateService(ServiceShape service, ServiceTrait trait) {
        String value = trait.getSdkId();
        try {
            SdkServiceIdValidator.validateServiceId(value);
            return Optional.empty();
        }
        catch (IllegalArgumentException e) {
            return Optional.of(this.error((Shape)service, (FromSourceLocation)trait, e.getMessage()));
        }
    }

    private static boolean containsCompanyName(String value) {
        return COMPANY_NAMES.stream().anyMatch(value::contains);
    }

    private static Optional<String> endsWithForbiddenWord(String value) {
        String lowercase = value.toLowerCase(Locale.US);
        return DISALLOWED_ENDINGS.stream().filter(lowercase::endsWith).findFirst();
    }

    private static boolean validForPattern(String value) {
        return SERVICE_ID_PATTERN.matcher(value).find();
    }
}

