/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.protocols;

import java.util.List;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.BuilderRef;

public abstract class AwsProtocolTrait
extends AbstractTrait {
    private static final String HTTP = "http";
    private static final String EVENT_STREAM_HTTP = "eventStreamHttp";
    private final List<String> http;
    private final List<String> eventStreamHttp;

    AwsProtocolTrait(ShapeId id, Builder<?, ?> builder) {
        super(id, (FromSourceLocation)builder.getSourceLocation());
        this.http = (List)((Builder)builder).http.copy();
        this.eventStreamHttp = (List)((Builder)builder).eventStreamHttp.copy();
    }

    public List<String> getHttp() {
        return this.http;
    }

    public List<String> getEventStreamHttp() {
        return this.eventStreamHttp;
    }

    protected Node createNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder();
        builder.sourceLocation(this.getSourceLocation());
        if (!this.getHttp().isEmpty()) {
            builder.withMember(HTTP, (ToNode)Node.fromStrings(this.getHttp()));
        }
        if (!this.getEventStreamHttp().isEmpty()) {
            builder.withMember(EVENT_STREAM_HTTP, (ToNode)Node.fromStrings(this.getEventStreamHttp()));
        }
        return builder.build();
    }

    public static abstract class Builder<T extends Trait, B extends Builder>
    extends AbstractTraitBuilder<T, B> {
        private final BuilderRef<List<String>> http = BuilderRef.forList();
        private final BuilderRef<List<String>> eventStreamHttp = BuilderRef.forList();

        public B http(List<String> http) {
            this.http.clear();
            ((List)this.http.get()).addAll(http);
            return (B)((Object)this);
        }

        public B eventStreamHttp(List<String> eventStreamHttp) {
            this.eventStreamHttp.clear();
            ((List)this.eventStreamHttp.get()).addAll(eventStreamHttp);
            return (B)((Object)this);
        }

        public B fromNode(Node node) {
            ObjectNode objectNode = node.expectObjectNode();
            objectNode.getArrayMember(AwsProtocolTrait.HTTP).map(values -> Node.loadArrayOfString((String)AwsProtocolTrait.HTTP, (Node)values)).ifPresent(this::http);
            objectNode.getArrayMember(AwsProtocolTrait.EVENT_STREAM_HTTP).map(values -> Node.loadArrayOfString((String)AwsProtocolTrait.EVENT_STREAM_HTTP, (Node)values)).ifPresent(this::eventStreamHttp);
            return (B)((Object)this);
        }
    }
}

