/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.auth;

import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class SigV4Trait
extends AbstractTrait
implements ToSmithyBuilder<SigV4Trait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.auth#sigv4");
    private static final String NAME = "name";
    private final String name;

    private SigV4Trait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.name = (String)SmithyBuilder.requiredState((String)NAME, (Object)builder.name);
    }

    public String getName() {
        return this.name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return (Builder)SigV4Trait.builder().name(this.getName()).sourceLocation((FromSourceLocation)this.getSourceLocation());
    }

    protected Node createNode() {
        return Node.objectNodeBuilder().sourceLocation(this.getSourceLocation()).withMember(NAME, this.getName()).build();
    }

    public static final class Builder
    extends AbstractTraitBuilder<SigV4Trait, Builder> {
        private String name;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public SigV4Trait build() {
            return new SigV4Trait(this);
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)SigV4Trait.builder().sourceLocation((FromSourceLocation)value);
            ObjectNode objectNode = value.expectObjectNode();
            builder.name(objectNode.expectStringMember(SigV4Trait.NAME).getValue());
            return builder.build();
        }
    }
}

