/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import software.amazon.smithy.aws.traits.HttpChecksumTrait;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.HttpPrefixHeadersTrait;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class HttpChecksumTraitValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (OperationShape operation : model.getOperationShapesWithTrait(HttpChecksumTrait.class)) {
            events.addAll(this.validateOperation(model, operation));
        }
        return events;
    }

    private List<ValidationEvent> validateOperation(Model model, OperationShape operation) {
        boolean isResponseChecksumConfiguration;
        HttpChecksumTrait trait = (HttpChecksumTrait)operation.expectTrait(HttpChecksumTrait.class);
        boolean isRequestChecksumConfiguration = trait.isRequestChecksumRequired() || trait.getRequestAlgorithmMember().isPresent();
        boolean bl = isResponseChecksumConfiguration = !trait.getResponseAlgorithms().isEmpty() || trait.getRequestValidationModeMember().isPresent();
        if (!isRequestChecksumConfiguration && !isResponseChecksumConfiguration) {
            return ListUtils.of((Object)this.error((Shape)operation, (FromSourceLocation)trait, "The `httpChecksum` trait must define at least one of the `request` or `response` checksum behaviors."));
        }
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        operation.getInput().ifPresent(inputId -> {
            StructureShape input = (StructureShape)model.expectShape(inputId, StructureShape.class);
            if (isRequestChecksumConfiguration) {
                events.addAll(this.validateRequestChecksumConfiguration(model, trait, operation, input));
            }
            if (isResponseChecksumConfiguration) {
                events.addAll(this.validateResponseChecksumConfiguration(model, trait, operation, input));
            }
        });
        return events;
    }

    private List<ValidationEvent> validateRequestChecksumConfiguration(Model model, HttpChecksumTrait trait, OperationShape operation, StructureShape input) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        this.validateAlgorithmMember(model, trait, operation, input).ifPresent(events::add);
        events.addAll(this.validateHeaderConflicts(operation, input));
        return events;
    }

    private Optional<ValidationEvent> validateAlgorithmMember(Model model, HttpChecksumTrait trait, OperationShape operation, StructureShape input) {
        if (trait.getRequestAlgorithmMember().isPresent()) {
            return this.validateEnumMember(model, trait, "requestAlgorithmMember", operation, input, trait.getRequestAlgorithmMember().get(), HttpChecksumTrait.CHECKSUM_ALGORITHMS);
        }
        return Optional.empty();
    }

    private Optional<ValidationEvent> validateEnumMember(Model model, HttpChecksumTrait trait, String traitProperty, OperationShape operation, StructureShape input, String memberName, List<String> supportedValues) {
        Optional member = input.getMember(memberName);
        if (!member.isPresent()) {
            return Optional.of(this.error((Shape)operation, (FromSourceLocation)trait, String.format("The `%s` property of the `httpChecksum` trait targets a member that does not exist.", traitProperty)));
        }
        Optional enumTraitOptional = ((MemberShape)member.get()).getMemberTrait(model, EnumTrait.class);
        ArrayList<String> unsupportedValues = new ArrayList<String>();
        if (enumTraitOptional.isPresent()) {
            for (String value : ((EnumTrait)enumTraitOptional.get()).getEnumDefinitionValues()) {
                if (supportedValues.contains(value)) continue;
                unsupportedValues.add(value);
            }
        } else {
            return Optional.of(this.error((Shape)operation, (FromSourceLocation)trait, String.format("The `%s` property of the `httpChecksum` trait targets a member that does not resolve an `enum` trait.", traitProperty)));
        }
        if (unsupportedValues.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.error((Shape)operation, (FromSourceLocation)trait, String.format("The `%s` property of the `httpChecksum` trait targets a member with an `enum` trait that contains unsupported values: %s", traitProperty, ValidationUtils.tickedList(unsupportedValues))));
    }

    private List<ValidationEvent> validateHeaderConflicts(OperationShape operation, StructureShape containerShape) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (MemberShape member : containerShape.members()) {
            member.getTrait(HttpPrefixHeadersTrait.class).map(StringTrait::getValue).ifPresent(headerPrefix -> {
                if ("x-amz-checksum-".startsWith((String)headerPrefix)) {
                    events.add(this.danger((Shape)operation, String.format("The `httpPrefixHeaders` binding of `%s` uses the prefix `%s` that conflicts with the prefix `%s` used by the `httpChecksum` trait.", member.getId().getName(), headerPrefix.toLowerCase(Locale.US), "x-amz-checksum-")));
                }
            });
            member.getTrait(HttpHeaderTrait.class).map(StringTrait::getValue).ifPresent(headerName -> {
                if (headerName.startsWith("x-amz-checksum-")) {
                    events.add(this.warning((Shape)operation, String.format("The `httpHeader` binding of `%s` on `%s` starts with the prefix `%s` used by the `httpChecksum` trait.", headerName.toLowerCase(Locale.US), member.getId().getName(), "x-amz-checksum-")));
                }
            });
        }
        return events;
    }

    private List<ValidationEvent> validateResponseChecksumConfiguration(Model model, HttpChecksumTrait trait, OperationShape operation, StructureShape input) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        if (operation.getOutput().isPresent()) {
            StructureShape outputShape = (StructureShape)model.expectShape((ShapeId)operation.getOutput().get(), StructureShape.class);
            events.addAll(this.validateHeaderConflicts(operation, outputShape));
        } else {
            events.add(this.error((Shape)operation, (FromSourceLocation)trait, "The `httpChecksum` trait defines `response` checksum behavior but the operation does not have output."));
        }
        if (!trait.getRequestValidationModeMember().isPresent()) {
            events.add(this.error((Shape)operation, (FromSourceLocation)trait, "The `httpChecksum` trait must model the `requestValidationModeMember` property to support response checksum behavior."));
            return events;
        }
        this.validateValidationModeMember(model, trait, operation, input).map(events::add);
        if (!operation.getErrors().isEmpty()) {
            for (ShapeId id : operation.getErrors()) {
                StructureShape shape = (StructureShape)model.expectShape(id, StructureShape.class);
                events.addAll(this.validateHeaderConflicts(operation, shape));
            }
        }
        return events;
    }

    private Optional<ValidationEvent> validateValidationModeMember(Model model, HttpChecksumTrait trait, OperationShape operation, StructureShape input) {
        return this.validateEnumMember(model, trait, "requestValidationModeMember", operation, input, trait.getRequestValidationModeMember().get(), HttpChecksumTrait.VALIDATION_MODES);
    }
}

