/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.traits.auth.SigV4Trait;
import software.amazon.smithy.aws.traits.protocols.AwsProtocolTrait;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.HttpChecksumProperty;
import software.amazon.smithy.model.traits.HttpChecksumTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class HttpChecksumTraitValidator
extends AbstractValidator {
    protected Supplier<List<Class<? extends Trait>>> targetProtocolSupplier() {
        return () -> ListUtils.of(AwsProtocolTrait.class);
    }

    protected Supplier<Set<HttpChecksumProperty>> supportedRequestChecksumSupplier() {
        HttpChecksumProperty.Builder builder = HttpChecksumProperty.builder();
        return () -> SetUtils.of((Object[])new HttpChecksumProperty[]{builder.algorithm("sha1").location("header").name("x-amz-checksum-sha1").build(), builder.algorithm("sha1").location("trailer").name("x-amz-checksum-sha1").build(), builder.algorithm("sha256").location("header").name("x-amz-checksum-sha256").build(), builder.algorithm("sha256").location("trailer").name("x-amz-checksum-sha256").build(), builder.algorithm("crc32").location("header").name("x-amz-checksum-crc32").build(), builder.algorithm("crc32").location("trailer").name("x-amz-checksum-crc32").build(), builder.algorithm("crc32c").location("header").name("x-amz-checksum-crc32c").build(), builder.algorithm("crc32c").location("trailer").name("x-amz-checksum-crc32c").build()});
    }

    protected Supplier<Set<HttpChecksumProperty>> supportedResponseChecksumSupplier() {
        HttpChecksumProperty.Builder builder = HttpChecksumProperty.builder();
        return () -> SetUtils.of((Object[])new HttpChecksumProperty[]{builder.algorithm("sha1").location("header").name("x-amz-checksum-sha1").build(), builder.algorithm("sha256").location("header").name("x-amz-checksum-sha256").build(), builder.algorithm("crc32").location("header").name("x-amz-checksum-crc32").build(), builder.algorithm("crc32c").location("header").name("x-amz-checksum-crc32c").build()});
    }

    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        ServiceIndex serviceIndex = ServiceIndex.of((Model)model);
        TopDownIndex topDownIndex = TopDownIndex.of((Model)model);
        List services = model.shapes(ServiceShape.class).collect(Collectors.toList());
        Supplier<List<Class<? extends Trait>>> protocolSupplier = this.targetProtocolSupplier();
        if (protocolSupplier == null) {
            throw new ExpectationNotMetException("Expected non null supplier for the list of target protocols for validation, found null.", (FromSourceLocation)SourceLocation.NONE);
        }
        Supplier<Set<HttpChecksumProperty>> requestChecksumSupplier = this.supportedRequestChecksumSupplier();
        if (requestChecksumSupplier == null) {
            throw new ExpectationNotMetException("Expected non null supplier for supported request checksum behavior , found null.", (FromSourceLocation)SourceLocation.NONE);
        }
        Supplier<Set<HttpChecksumProperty>> responseChecksumSupplier = this.supportedResponseChecksumSupplier();
        if (responseChecksumSupplier == null) {
            throw new ExpectationNotMetException("Expected non null supplier for supported response checksum behavior , found null.", (FromSourceLocation)SourceLocation.NONE);
        }
        for (ServiceShape service : services) {
            if (!this.isTargetProtocol(protocolSupplier, service)) continue;
            for (OperationShape operation : topDownIndex.getContainedOperations((ToShapeId)service)) {
                if (!operation.hasTrait(HttpChecksumTrait.class)) continue;
                events.addAll(this.validateBehaviorIsSupported(operation, requestChecksumSupplier, responseChecksumSupplier));
                events.addAll(this.validateRequestSupportsHeaderLocation(serviceIndex, service, operation));
            }
        }
        return events;
    }

    private List<ValidationEvent> validateBehaviorIsSupported(OperationShape operation, Supplier<Set<HttpChecksumProperty>> requestChecksumSupplier, Supplier<Set<HttpChecksumProperty>> responseChecksumSupplier) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        HttpChecksumTrait trait = (HttpChecksumTrait)operation.expectTrait(HttpChecksumTrait.class);
        String formattedError = "The checksum behavior for %s with algorithm \"%s\", location \"%s\" and name \"%s\" is not supported.";
        Set<HttpChecksumProperty> validRequestChecksumBehavior = requestChecksumSupplier.get();
        for (HttpChecksumProperty property : trait.getRequestProperties()) {
            if (validRequestChecksumBehavior != null && validRequestChecksumBehavior.contains(property)) continue;
            events.add(this.error((Shape)operation, (FromSourceLocation)trait, String.format(formattedError, "request", property.getAlgorithm(), property.getLocation(), property.getName())));
        }
        Set<HttpChecksumProperty> validResponseChecksumBehavior = responseChecksumSupplier.get();
        for (HttpChecksumProperty property : trait.getResponseProperties()) {
            if (validResponseChecksumBehavior != null && validResponseChecksumBehavior.contains(property)) continue;
            events.add(this.error((Shape)operation, (FromSourceLocation)trait, String.format(formattedError, "response", property.getAlgorithm(), property.getLocation(), property.getName())));
        }
        return events;
    }

    private List<ValidationEvent> validateRequestSupportsHeaderLocation(ServiceIndex serviceIndex, ServiceShape service, OperationShape operation) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        HttpChecksumTrait trait = (HttpChecksumTrait)operation.expectTrait(HttpChecksumTrait.class);
        if (this.hasSigV4AuthScheme(serviceIndex, service, operation)) {
            for (String algorithm : trait.getRequestAlgorithms()) {
                Boolean supportsHeaderAsLocation = trait.getRequestPropertiesForAlgorithm(algorithm).stream().anyMatch(p -> p.getLocation().equals((Object)HttpChecksumProperty.Location.HEADER));
                if (supportsHeaderAsLocation.booleanValue()) continue;
                events.add(this.error((Shape)operation, (FromSourceLocation)trait, String.format("Operations that support the `sigv4` trait MUST support the `header` checksum location on `request`, \"%s\" does not for \"%s\" algorithm.", operation.getId().getName(service), algorithm)));
            }
        }
        return events;
    }

    private boolean isTargetProtocol(Supplier<List<Class<? extends Trait>>> supplier, ServiceShape service) {
        List<Class<? extends Trait>> list = supplier.get();
        if (list == null) {
            return false;
        }
        for (Class<? extends Trait> t : list) {
            if (!service.hasTrait(t)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSigV4AuthScheme(ServiceIndex serviceIndex, ServiceShape service, OperationShape operation) {
        Map auth = serviceIndex.getEffectiveAuthSchemes((ToShapeId)service.getId(), (ToShapeId)operation.getId());
        return auth.containsKey(SigV4Trait.ID);
    }
}

