/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class CognitoUserPoolsTrait
extends AbstractTrait
implements ToSmithyBuilder<CognitoUserPoolsTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.auth#cognitoUserPools");
    private static final String PROVIDER_ARNS = "providerArns";
    private final List<String> providerArns;

    private CognitoUserPoolsTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.providerArns = ListUtils.copyOf((Collection)((Collection)SmithyBuilder.requiredState((String)PROVIDER_ARNS, (Object)builder.providerArns)));
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> getProviderArns() {
        return this.providerArns;
    }

    public Builder toBuilder() {
        return CognitoUserPoolsTrait.builder().providerArns(this.providerArns);
    }

    protected Node createNode() {
        return Node.objectNode().withMember(PROVIDER_ARNS, (ToNode)((ArrayNode)this.providerArns.stream().map(Node::from).collect(ArrayNode.collect())));
    }

    public static final class Builder
    extends AbstractTraitBuilder<CognitoUserPoolsTrait, Builder> {
        private final List<String> providerArns = new ArrayList<String>();

        private Builder() {
        }

        public CognitoUserPoolsTrait build() {
            return new CognitoUserPoolsTrait(this);
        }

        public Builder providerArns(List<String> providerArns) {
            this.clearProviderArns();
            this.providerArns.addAll(providerArns);
            return this;
        }

        public Builder addProviderArn(String arn) {
            this.providerArns.add(arn);
            return this;
        }

        public Builder clearProviderArns() {
            this.providerArns.clear();
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            ObjectNode objectNode = value.expectObjectNode();
            return CognitoUserPoolsTrait.builder().providerArns(objectNode.expectArrayMember(CognitoUserPoolsTrait.PROVIDER_ARNS).getElementsAs(StringNode::getValue)).build();
        }
    }
}

