/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits;

import java.util.Locale;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ServiceTrait
extends AbstractTrait
implements ToSmithyBuilder<ServiceTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.api#service");
    private final String abbreviation;
    private final String cloudFormationName;
    private final String arnNamespace;
    private final String sdkId;
    private final String cloudTrailEventSource;

    private ServiceTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.sdkId = (String)SmithyBuilder.requiredState((String)"sdkId", (Object)builder.sdkId);
        this.arnNamespace = (String)SmithyBuilder.requiredState((String)"arnNamespace", (Object)builder.arnNamespace);
        this.cloudFormationName = (String)SmithyBuilder.requiredState((String)"cloudFormationName", (Object)builder.cloudFormationName);
        this.cloudTrailEventSource = (String)SmithyBuilder.requiredState((String)"cloudTrailEventSource", (Object)builder.cloudTrailEventSource);
        this.abbreviation = builder.abbreviation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getArnNamespace() {
        return this.arnNamespace;
    }

    public String getCloudFormationName() {
        return this.cloudFormationName;
    }

    public String getSdkId() {
        return this.sdkId;
    }

    public String getCloudTrailEventSource() {
        return this.cloudTrailEventSource;
    }

    public Optional<String> getAbbreviation() {
        return Optional.ofNullable(this.abbreviation);
    }

    public Builder toBuilder() {
        return ((Builder)new Builder().sdkId(this.sdkId).sourceLocation((FromSourceLocation)this.getSourceLocation())).cloudFormationName(this.cloudFormationName).arnNamespace(this.arnNamespace).cloudTrailEventSource(this.cloudTrailEventSource).abbreviation(this.abbreviation);
    }

    protected Node createNode() {
        return Node.objectNode().withMember("sdkId", (ToNode)Node.from((String)this.sdkId)).withMember("arnNamespace", (ToNode)Node.from((String)this.getArnNamespace())).withMember("cloudFormationName", (ToNode)Node.from((String)this.getCloudFormationName())).withMember("cloudTrailEventSource", (ToNode)Node.from((String)this.getCloudTrailEventSource())).withOptionalMember("abbreviation", this.getAbbreviation().map(Node::from));
    }

    public static final class Builder
    extends AbstractTraitBuilder<ServiceTrait, Builder> {
        private String abbreviation;
        private String sdkId;
        private String cloudFormationName;
        private String arnNamespace;
        private String cloudTrailEventSource;

        private Builder() {
        }

        public ServiceTrait build() {
            return new ServiceTrait(this);
        }

        public ServiceTrait build(ShapeId target) {
            if (this.arnNamespace == null) {
                this.arnNamespace(target.getName().toLowerCase(Locale.US));
            }
            if (this.cloudFormationName == null) {
                this.cloudFormationName(target.getName());
            }
            if (this.cloudTrailEventSource == null) {
                this.cloudTrailEventSource = this.arnNamespace + ".amazonaws.com";
            }
            return new ServiceTrait(this);
        }

        public Builder cloudFormationName(String cloudFormationName) {
            this.cloudFormationName = cloudFormationName;
            return this;
        }

        public Builder arnNamespace(String arnNamespace) {
            this.arnNamespace = arnNamespace;
            return this;
        }

        public Builder sdkId(String sdkId) {
            this.sdkId = sdkId;
            return this;
        }

        public Builder cloudTrailEventSource(String cloudTrailEventSource) {
            this.cloudTrailEventSource = cloudTrailEventSource;
            return this;
        }

        public Builder abbreviation(String abbreviation) {
            this.abbreviation = abbreviation;
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            ObjectNode objectNode = value.expectObjectNode();
            Builder builder = ServiceTrait.builder();
            String sdkId = objectNode.getStringMember("sdkId").map(StringNode::getValue).orElseThrow(() -> new SourceException(String.format("No sdkId was provided. Perhaps you could set this to %s?", target.getName()), (FromSourceLocation)value));
            builder.sdkId(sdkId);
            objectNode.getStringMember("arnNamespace").map(StringNode::getValue).ifPresent(builder::arnNamespace);
            objectNode.getStringMember("cloudFormationName").map(StringNode::getValue).ifPresent(builder::cloudFormationName);
            objectNode.getStringMember("cloudTrailEventSource").map(StringNode::getValue).ifPresent(builder::cloudTrailEventSource);
            objectNode.getStringMember("abbreviation").map(StringNode::getValue).ifPresent(builder::abbreviation);
            return builder.build(target);
        }
    }
}

