/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.iam;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.traits.ServiceTrait;
import software.amazon.smithy.aws.traits.iam.ConditionKeysIndex;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;

public class ConditionKeysValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ConditionKeysIndex conditionIndex = (ConditionKeysIndex)model.getKnowledge(ConditionKeysIndex.class);
        TopDownIndex topDownIndex = (TopDownIndex)model.getKnowledge(TopDownIndex.class);
        return model.shapes(ServiceShape.class).filter(service -> service.hasTrait(ServiceTrait.class)).flatMap(service -> {
            ArrayList<ValidationEvent> results = new ArrayList<ValidationEvent>();
            Set<String> knownKeys = conditionIndex.getDefinedConditionKeys((ToShapeId)service).keySet();
            for (OperationShape operation : topDownIndex.getContainedOperations((ToShapeId)service)) {
                for (String name : conditionIndex.getConditionKeyNames((ToShapeId)service, (ToShapeId)operation)) {
                    if (knownKeys.contains(name) || name.startsWith("aws:")) continue;
                    results.add(this.error((Shape)operation, String.format("This operation scoped within the `%s` service refers to an undefined condition key `%s`. Expected one of the following defined condition keys: [%s]", service.getId(), name, ValidationUtils.tickedList(knownKeys))));
                }
            }
            return results.stream();
        }).collect(Collectors.toList());
    }
}

