/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.clientendpointdiscovery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.traits.clientendpointdiscovery.ClientDiscoveredEndpointTrait;
import software.amazon.smithy.aws.traits.clientendpointdiscovery.ClientEndpointDiscoveryIdTrait;
import software.amazon.smithy.aws.traits.clientendpointdiscovery.ClientEndpointDiscoveryInfo;
import software.amazon.smithy.aws.traits.clientendpointdiscovery.ClientEndpointDiscoveryTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.Pair;

public final class ClientEndpointDiscoveryIndex
implements KnowledgeIndex {
    private final Map<ShapeId, Map<ShapeId, ClientEndpointDiscoveryInfo>> endpointDiscoveryInfo = new HashMap<ShapeId, Map<ShapeId, ClientEndpointDiscoveryInfo>>();

    public ClientEndpointDiscoveryIndex(Model model) {
        ShapeIndex index = model.getShapeIndex();
        TopDownIndex topDownIndex = (TopDownIndex)model.getKnowledge(TopDownIndex.class);
        OperationIndex opIndex = (OperationIndex)model.getKnowledge(OperationIndex.class);
        index.shapes(ServiceShape.class).flatMap(service -> Trait.flatMapStream((Shape)service, ClientEndpointDiscoveryTrait.class)).forEach(servicePair -> {
            Map<ShapeId, ClientEndpointDiscoveryInfo> serviceInfo;
            ServiceShape service = (ServiceShape)servicePair.getLeft();
            ShapeId endpointOperationId = ((ClientEndpointDiscoveryTrait)((Object)((Object)servicePair.getRight()))).getOperation();
            ShapeId endpointErrorId = ((ClientEndpointDiscoveryTrait)((Object)((Object)servicePair.getRight()))).getError();
            Optional endpointOperation = index.getShape(endpointOperationId).flatMap(Shape::asOperationShape);
            Optional endpointError = index.getShape(endpointErrorId).flatMap(Shape::asStructureShape);
            if (endpointOperation.isPresent() && endpointError.isPresent() && !(serviceInfo = this.getOperations(service, (OperationShape)endpointOperation.get(), (StructureShape)endpointError.get(), topDownIndex, opIndex)).isEmpty()) {
                this.endpointDiscoveryInfo.put(service.getId(), serviceInfo);
            }
        });
    }

    private Map<ShapeId, ClientEndpointDiscoveryInfo> getOperations(ServiceShape service, OperationShape endpointOperation, StructureShape endpointError, TopDownIndex topDownIndex, OperationIndex opIndex) {
        return topDownIndex.getContainedOperations((ToShapeId)service).stream().flatMap(operation -> Trait.flatMapStream((Shape)operation, ClientDiscoveredEndpointTrait.class)).map(pair -> {
            OperationShape operation = (OperationShape)pair.getLeft();
            List<MemberShape> discoveryIds = this.getDiscoveryIds(opIndex, operation);
            ClientEndpointDiscoveryInfo info = new ClientEndpointDiscoveryInfo(service, operation, endpointOperation, endpointError, discoveryIds, ((ClientDiscoveredEndpointTrait)((Object)((Object)pair.getRight()))).isRequired());
            return Pair.of((Object)operation.getId(), (Object)info);
        }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    private List<MemberShape> getDiscoveryIds(OperationIndex opIndex, OperationShape operation) {
        ArrayList<MemberShape> discoveryIds = new ArrayList<MemberShape>();
        opIndex.getInput((ToShapeId)operation).ifPresent(input -> input.getAllMembers().values().stream().filter(member -> member.hasTrait(ClientEndpointDiscoveryIdTrait.class)).forEach(discoveryIds::add));
        return discoveryIds;
    }

    public Optional<ClientEndpointDiscoveryInfo> getEndpointDiscoveryInfo(ToShapeId service, ToShapeId operation) {
        return Optional.ofNullable(this.endpointDiscoveryInfo.get(service.toShapeId())).flatMap(mappings -> Optional.ofNullable((ClientEndpointDiscoveryInfo)mappings.get(operation.toShapeId())));
    }

    public Set<ShapeId> getEndpointDiscoveryOperations(ToShapeId service) {
        return Optional.ofNullable(this.endpointDiscoveryInfo.get(service.toShapeId())).flatMap(mappings -> Optional.of(mappings.keySet())).orElse(new HashSet());
    }
}

