/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.apigateway;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class IntegrationResponse
implements ToNode,
ToSmithyBuilder<IntegrationResponse> {
    private static final String STATUS_CODE_KEY = "statusCode";
    private static final String CONTENT_HANDLING_KEY = "contentHandling";
    private static final String RESPONSE_TEMPLATES_KEY = "responseTemplates";
    private static final String RESPONSE_PARAMETERS_KEY = "responseParameters";
    private final String statusCode;
    private final String contentHandling;
    private final Map<String, String> responseTemplates;
    private final Map<String, String> responseParameters;
    private final FromSourceLocation sourceLocation;

    private IntegrationResponse(Builder builder) {
        this.statusCode = builder.statusCode;
        this.contentHandling = builder.contentHandling;
        this.responseTemplates = MapUtils.copyOf((Map)builder.responseTemplates);
        this.responseParameters = MapUtils.copyOf((Map)builder.responseParameters);
        this.sourceLocation = builder.sourceLocation;
    }

    public static Builder builder() {
        return new Builder();
    }

    static IntegrationResponse fromNode(Node value) {
        Objects.requireNonNull(value);
        ObjectNode obj = value.expectObjectNode();
        Builder builder = IntegrationResponse.builder().sourceLocation((FromSourceLocation)value);
        builder.statusCode(obj.expectStringMember(STATUS_CODE_KEY).getValue());
        obj.getStringMember(CONTENT_HANDLING_KEY).map(StringNode::getValue).ifPresent(builder::contentHandling);
        obj.getObjectMember(RESPONSE_TEMPLATES_KEY).map(ObjectNode::getMembers).map(Map::entrySet).ifPresent(entrySet -> entrySet.forEach(entry -> builder.putResponseTemplate(((StringNode)entry.getKey()).getValue(), ((Node)entry.getValue()).expectStringNode().getValue())));
        obj.getObjectMember(RESPONSE_PARAMETERS_KEY).map(ObjectNode::getMembers).map(Map::entrySet).ifPresent(entrySet -> entrySet.forEach(entry -> builder.putResponseParameter(((StringNode)entry.getKey()).getValue(), ((Node)entry.getValue()).expectStringNode().getValue())));
        return builder.build();
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public Optional<String> getContentHandling() {
        return Optional.ofNullable(this.contentHandling);
    }

    public Map<String, String> getAllResponseTemplates() {
        return this.responseTemplates;
    }

    public Optional<String> getResponseTemplate(String mimeType) {
        return Optional.ofNullable(this.responseTemplates.get(mimeType));
    }

    public Map<String, String> getAllResponseParameters() {
        return this.responseParameters;
    }

    public Optional<String> getResponseParameter(String name) {
        return Optional.ofNullable(this.responseParameters.get(name));
    }

    public Builder toBuilder() {
        Builder builder = IntegrationResponse.builder();
        this.responseTemplates.forEach(builder::putResponseTemplate);
        this.responseParameters.forEach(builder::putResponseParameter);
        return builder.sourceLocation(this.sourceLocation).contentHandling(this.contentHandling).statusCode(this.statusCode);
    }

    public Node toNode() {
        return Node.objectNodeBuilder().withMember(STATUS_CODE_KEY, this.statusCode).withOptionalMember(CONTENT_HANDLING_KEY, this.getContentHandling().map(Node::from)).withOptionalMember(RESPONSE_TEMPLATES_KEY, this.responseTemplates.size() > 0 ? Optional.of(ObjectNode.fromStringMap(this.responseTemplates)) : Optional.empty()).withOptionalMember(RESPONSE_PARAMETERS_KEY, this.responseParameters.size() > 0 ? Optional.of(ObjectNode.fromStringMap(this.responseParameters)) : Optional.empty()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntegrationResponse)) {
            return false;
        }
        IntegrationResponse other = (IntegrationResponse)o;
        return this.toNode().equals(other.toNode());
    }

    public int hashCode() {
        return this.toNode().hashCode();
    }

    public static final class Builder
    implements SmithyBuilder<IntegrationResponse> {
        private String statusCode;
        private String contentHandling;
        private Map<String, String> responseTemplates = new HashMap<String, String>();
        private Map<String, String> responseParameters = new HashMap<String, String>();
        private FromSourceLocation sourceLocation;

        public IntegrationResponse build() {
            return new IntegrationResponse(this);
        }

        public Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder contentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        public Builder putResponseTemplate(String mimeType, String template) {
            this.responseTemplates.put(mimeType, template);
            return this;
        }

        public Builder removeResponseTemplate(String mimeType) {
            this.responseTemplates.remove(mimeType);
            return this;
        }

        public Builder putResponseParameter(String name, String value) {
            this.responseParameters.put(name, value);
            return this;
        }

        public Builder removeResponseParameter(String name) {
            this.responseParameters.remove(name);
            return this;
        }

        Builder sourceLocation(FromSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }
    }
}

