/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.clientendpointdiscovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.traits.clientendpointdiscovery.ClientDiscoveredEndpointTrait;
import software.amazon.smithy.aws.traits.clientendpointdiscovery.ClientEndpointDiscoveryIndex;
import software.amazon.smithy.aws.traits.clientendpointdiscovery.ClientEndpointDiscoveryInfo;
import software.amazon.smithy.aws.traits.clientendpointdiscovery.ClientEndpointDiscoveryTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.SetUtils;

public class ClientEndpointDiscoveryValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ShapeIndex shapeIndex = model.getShapeIndex();
        ClientEndpointDiscoveryIndex discoveryIndex = (ClientEndpointDiscoveryIndex)model.getKnowledge(ClientEndpointDiscoveryIndex.class);
        OperationIndex opIndex = (OperationIndex)model.getKnowledge(OperationIndex.class);
        Map<ServiceShape, ClientEndpointDiscoveryTrait> endpointDiscoveryServices = shapeIndex.shapes(ServiceShape.class).flatMap(service -> Trait.flatMapStream((Shape)service, ClientEndpointDiscoveryTrait.class)).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        List<ValidationEvent> validationEvents = endpointDiscoveryServices.values().stream().map(ClientEndpointDiscoveryTrait::getOperation).map(operation -> shapeIndex.getShape(operation).flatMap(Shape::asOperationShape)).filter(Optional::isPresent).map(Optional::get).flatMap(endpointOperation -> this.validateEndpointOperation(shapeIndex, opIndex, (OperationShape)endpointOperation).stream()).collect(Collectors.toList());
        validationEvents.addAll(this.validateServices(discoveryIndex, endpointDiscoveryServices));
        validationEvents.addAll(this.validateOperations(shapeIndex, discoveryIndex, endpointDiscoveryServices));
        return validationEvents;
    }

    private List<ValidationEvent> validateServices(ClientEndpointDiscoveryIndex discoveryIndex, Map<ServiceShape, ClientEndpointDiscoveryTrait> endpointDiscoveryServices) {
        List<ValidationEvent> validationEvents = endpointDiscoveryServices.entrySet().stream().filter(pair -> !((ServiceShape)pair.getKey()).getAllOperations().contains(((ClientEndpointDiscoveryTrait)((Object)((Object)pair.getValue()))).getOperation())).map(pair -> this.error((Shape)pair.getKey(), String.format("The operation `%s` must be bound to the service `%s` to use it as the endpoint operation.", ((ClientEndpointDiscoveryTrait)((Object)((Object)pair.getValue()))).getOperation(), pair.getKey()))).collect(Collectors.toList());
        validationEvents.addAll(endpointDiscoveryServices.keySet().stream().filter(service -> discoveryIndex.getEndpointDiscoveryOperations((ToShapeId)service).isEmpty()).map(service -> this.warning((Shape)service, String.format("The service `%s` is configured to use endpoint discovery, but has no operations bound with the `%s` trait.", service.getId().toString(), ClientDiscoveredEndpointTrait.ID.toString()))).collect(Collectors.toList()));
        return validationEvents;
    }

    private List<ValidationEvent> validateOperations(ShapeIndex shapeIndex, ClientEndpointDiscoveryIndex discoveryIndex, Map<ServiceShape, ClientEndpointDiscoveryTrait> endpointDiscoveryServices) {
        return shapeIndex.shapes(OperationShape.class).filter(operation -> operation.hasTrait(ClientDiscoveredEndpointTrait.class)).map(operation -> {
            List infos = endpointDiscoveryServices.keySet().stream().map(service -> discoveryIndex.getEndpointDiscoveryInfo((ToShapeId)service, (ToShapeId)operation)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            return Pair.of((Object)operation, infos);
        }).flatMap(pair -> this.validateOperation((OperationShape)pair.getLeft(), (List)pair.getRight()).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateOperation(OperationShape operation, List<ClientEndpointDiscoveryInfo> infos) {
        if (infos.isEmpty()) {
            return Collections.singletonList(this.error((Shape)operation, String.format("The operation `%s` is marked with `%s` but is not attached to a service with the `%s` trait.", operation.getId().toString(), ClientDiscoveredEndpointTrait.ID.toString(), ClientEndpointDiscoveryTrait.ID.toString())));
        }
        return infos.stream().filter(discoveryInfo -> !operation.getErrors().contains(discoveryInfo.getError().getId())).map(discoveryInfo -> this.error((Shape)operation, String.format("The operation `%s` is marked with `%s` and is bound to the service `%s` but does not have the required error `%s`.", operation.getId(), ClientDiscoveredEndpointTrait.ID.toString(), discoveryInfo.getService().getId(), discoveryInfo.getError().getId()))).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateEndpointOperation(ShapeIndex shapeIndex, OperationIndex opIndex, OperationShape operation) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        opIndex.getInput((ToShapeId)operation).ifPresent(input -> {
            Set memberNames = SetUtils.copyOf((Collection)input.getMemberNames());
            if (!memberNames.equals(SetUtils.of((Object[])new String[]{"Operation", "Identifiers"}))) {
                events.add(this.error((Shape)input, String.format("Input for endpoint discovery operation `%s` may only have the members Operation and Identifiers but found: %s", operation.getId().toString(), String.join((CharSequence)", ", memberNames))));
            }
            input.getMember("Operation").flatMap(member -> shapeIndex.getShape(member.getTarget())).filter(shape -> !shape.isStringShape()).ifPresent(shape -> events.add(this.error((Shape)shape, "The Operation member of an endpoint discovery operation must be a string")));
            input.getMember("Identifiers").map(member -> Pair.of((Object)member, (Object)shapeIndex.getShape(member.getTarget()))).ifPresent(pair -> {
                Optional value;
                Optional map = ((Optional)pair.getRight()).flatMap(Shape::asMapShape);
                if (map.isPresent() && (value = shapeIndex.getShape(((MapShape)map.get()).getValue().getTarget())).isPresent() && ((Shape)value.get()).isStringShape()) {
                    return;
                }
                events.add(this.error((Shape)pair.getLeft(), "The Identifiers member of an endpoint discovery operation must be a map whose keys and values are strings."));
            });
        });
        Optional output = opIndex.getOutput((ToShapeId)operation);
        if (!output.isPresent()) {
            events.add(this.error((Shape)operation, "Endpoint discovery operations must have an output."));
            return events;
        }
        Map outputMembers = ((StructureShape)output.get()).getAllMembers();
        if (outputMembers.size() != 1 || !outputMembers.containsKey("Endpoints")) {
            events.add(this.error((Shape)output.get(), String.format("Endpoint discovery operation output may only contain an `Endpoints` member, but found: %s", String.join((CharSequence)",", outputMembers.keySet()))));
        }
        Optional.ofNullable((MemberShape)outputMembers.get("Endpoints")).map(member -> Pair.of((Object)member, (Object)shapeIndex.getShape(member.getTarget()))).ifPresent(pair -> {
            Set memberNames;
            Optional cachePeriodMember;
            Optional cachePeriod;
            Optional listShape = ((Optional)pair.getRight()).flatMap(Shape::asListShape);
            if (!listShape.isPresent()) {
                events.add(this.error((Shape)pair.getLeft(), "The output member `Endpoints` on an endpoint discovery operation must be a list."));
                return;
            }
            Optional listMember = shapeIndex.getShape(((ListShape)listShape.get()).getMember().getTarget()).flatMap(Shape::asStructureShape);
            if (!listMember.isPresent()) {
                events.add(this.error((Shape)listShape.get(), "The member of the Endpoints list in an endpoint discovery operation must be a structure shape."));
                return;
            }
            Optional addressMember = ((StructureShape)listMember.get()).getMember("Address");
            Optional address = addressMember.flatMap(member -> shapeIndex.getShape(member.getTarget()));
            if (address.isPresent() && !((Shape)address.get()).isStringShape()) {
                events.add(this.error((Shape)addressMember.get(), "The `Address` member of the `Endpoint` shape must be a string type."));
            }
            if ((cachePeriod = (cachePeriodMember = ((StructureShape)listMember.get()).getMember("CachePeriodInMinutes")).flatMap(member -> shapeIndex.getShape(member.getTarget()))).isPresent() && !((Shape)cachePeriod.get()).isLongShape()) {
                events.add(this.error((Shape)cachePeriodMember.get(), "The `CachePeriodInMinutes` member of the `Endpoint` shape must be a long type."));
            }
            if (!(memberNames = SetUtils.copyOf((Collection)((StructureShape)listMember.get()).getMemberNames())).equals(SetUtils.of((Object[])new String[]{"Address", "CachePeriodInMinutes"}))) {
                events.add(this.error((Shape)listMember.get(), String.format("The `Endpoint` shape must only have the members `Address` and `CachePeriodInMinutes`, but found: %s", String.join((CharSequence)", ", memberNames))));
            }
        });
        return events;
    }
}

