/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.clientendpointdiscovery;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ClientEndpointDiscoveryTrait
extends AbstractTrait
implements ToSmithyBuilder<ClientEndpointDiscoveryTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.api#clientEndpointDiscovery");
    private static final String OPERATION = "operation";
    private static final String ERROR = "error";
    private static final List<String> PROPERTIES = Collections.unmodifiableList(Arrays.asList("operation", "error"));
    private final ShapeId operation;
    private final ShapeId error;

    public ClientEndpointDiscoveryTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.operation = builder.operation;
        this.error = builder.error;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ShapeId getOperation() {
        return this.operation;
    }

    public ShapeId getError() {
        return this.error;
    }

    protected Node createNode() {
        return Node.objectNode().withMember(OPERATION, (ToNode)Node.from((String)this.getOperation().toString())).withMember(ERROR, (ToNode)Node.from((String)this.getError().toString()));
    }

    public Builder toBuilder() {
        return new Builder().operation(this.getOperation()).error(this.getError());
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public ClientEndpointDiscoveryTrait createTrait(ShapeId target, Node value) {
            ObjectNode objectNode = value.expectObjectNode();
            objectNode.warnIfAdditionalProperties((Collection)PROPERTIES);
            return ClientEndpointDiscoveryTrait.builder().operation(objectNode.expectStringMember(ClientEndpointDiscoveryTrait.OPERATION).expectShapeId()).error(objectNode.expectStringMember(ClientEndpointDiscoveryTrait.ERROR).expectShapeId()).build();
        }
    }

    public static final class Builder
    extends AbstractTraitBuilder<ClientEndpointDiscoveryTrait, Builder> {
        private ShapeId operation;
        private ShapeId error;

        private Builder() {
        }

        public ClientEndpointDiscoveryTrait build() {
            return new ClientEndpointDiscoveryTrait(this);
        }

        public Builder operation(ShapeId operation) {
            this.operation = operation;
            return this;
        }

        public Builder error(ShapeId error) {
            this.error = error;
            return this;
        }
    }
}

