/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.apigateway;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class AuthorizerDefinition
implements ToNode,
ToSmithyBuilder<AuthorizerDefinition> {
    private static final String SIGV4_AUTH_TYPE = "awsSigv4";
    private static final String DEFAULT_AUTH_TYPE = "custom";
    private static final String SCHEME_KEY = "scheme";
    private static final String TYPE_KEY = "type";
    private static final String AUTH_TYPE_KEY = "customAuthType";
    private static final String URI_KEY = "uri";
    private static final String CREDENTIALS_KEY = "credentials";
    private static final String IDENTITY_SOURCE_KEY = "identitySource";
    private static final String IDENTITY_VALIDATION_EXPRESSION_KEY = "identityValidationExpression";
    private static final String RESULT_TTL_IN_SECONDS = "resultTtlInSeconds";
    private static final List<String> PROPERTIES = ListUtils.of((Object[])new String[]{"scheme", "type", "customAuthType", "uri", "credentials", "identitySource", "identityValidationExpression", "resultTtlInSeconds"});
    private final String scheme;
    private final String type;
    private final String authType;
    private final String uri;
    private final String credentials;
    private final String identitySource;
    private final String identityValidationExpression;
    private final Integer resultTtlInSeconds;

    private AuthorizerDefinition(Builder builder) {
        this.scheme = (String)SmithyBuilder.requiredState((String)SCHEME_KEY, (Object)builder.scheme);
        this.type = builder.type;
        this.uri = builder.uri;
        this.authType = builder.authType;
        this.credentials = builder.credentials;
        this.identitySource = builder.identitySource;
        this.identityValidationExpression = builder.identityValidationExpression;
        this.resultTtlInSeconds = builder.resultTtlInSeconds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getScheme() {
        return this.scheme;
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this.type);
    }

    public Optional<String> getUri() {
        return Optional.ofNullable(this.uri);
    }

    public String getAuthType() {
        if (this.authType != null) {
            return this.authType;
        }
        if (this.scheme.equals("aws.v4")) {
            return SIGV4_AUTH_TYPE;
        }
        return DEFAULT_AUTH_TYPE;
    }

    public Optional<String> getCredentials() {
        return Optional.ofNullable(this.credentials);
    }

    public Optional<String> getIdentitySource() {
        return Optional.ofNullable(this.identitySource);
    }

    public Optional<String> getIdentityValidationExpression() {
        return Optional.ofNullable(this.identityValidationExpression);
    }

    public Optional<Integer> getResultTtlInSeconds() {
        return Optional.ofNullable(this.resultTtlInSeconds);
    }

    public Builder toBuilder() {
        return AuthorizerDefinition.builder().scheme(this.scheme).type(this.type).uri(this.uri).authType(this.authType).credentials(this.credentials).identitySource(this.identitySource).identityValidationExpression(this.identityValidationExpression).resultTtlInSeconds(this.resultTtlInSeconds);
    }

    public Node toNode() {
        return Node.objectNodeBuilder().withMember(SCHEME_KEY, (ToNode)Node.from((String)this.getScheme())).withOptionalMember(TYPE_KEY, this.getType().map(Node::from)).withOptionalMember(AUTH_TYPE_KEY, Optional.ofNullable(this.authType).map(Node::from)).withOptionalMember(URI_KEY, this.getUri().map(Node::from)).withOptionalMember(CREDENTIALS_KEY, this.getCredentials().map(Node::from)).withOptionalMember(IDENTITY_SOURCE_KEY, this.getIdentitySource().map(Node::from)).withOptionalMember(IDENTITY_VALIDATION_EXPRESSION_KEY, this.getIdentityValidationExpression().map(Node::from)).withOptionalMember(RESULT_TTL_IN_SECONDS, this.getResultTtlInSeconds().map(Node::from)).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthorizerDefinition)) {
            return false;
        }
        AuthorizerDefinition that = (AuthorizerDefinition)o;
        return this.scheme.equals(that.scheme) && Objects.equals(this.type, that.type) && Objects.equals(this.uri, that.uri) && Objects.equals(this.authType, that.authType) && Objects.equals(this.credentials, that.credentials) && Objects.equals(this.identitySource, that.identitySource) && Objects.equals(this.identityValidationExpression, that.identityValidationExpression) && Objects.equals(this.resultTtlInSeconds, that.resultTtlInSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.type, this.uri);
    }

    static AuthorizerDefinition fromNode(ObjectNode node) {
        node.warnIfAdditionalProperties(PROPERTIES);
        Builder builder = AuthorizerDefinition.builder();
        builder.scheme(node.expectStringMember(SCHEME_KEY).getValue());
        node.getStringMember(TYPE_KEY).map(StringNode::getValue).ifPresent(builder::type);
        node.getStringMember(AUTH_TYPE_KEY).map(StringNode::getValue).ifPresent(builder::authType);
        node.getStringMember(URI_KEY).map(StringNode::getValue).ifPresent(builder::uri);
        node.getStringMember(CREDENTIALS_KEY).map(StringNode::getValue).ifPresent(builder::credentials);
        node.getStringMember(IDENTITY_SOURCE_KEY).map(StringNode::getValue).ifPresent(builder::identitySource);
        node.getStringMember(IDENTITY_VALIDATION_EXPRESSION_KEY).map(StringNode::getValue).ifPresent(builder::identityValidationExpression);
        node.getNumberMember(RESULT_TTL_IN_SECONDS).map(NumberNode::getValue).map(Number::intValue).ifPresent(builder::resultTtlInSeconds);
        return builder.build();
    }

    public static final class Builder
    implements SmithyBuilder<AuthorizerDefinition> {
        private String scheme;
        private String type;
        private String authType;
        private String uri;
        private String credentials;
        private String identitySource;
        private String identityValidationExpression;
        private Integer resultTtlInSeconds;

        public AuthorizerDefinition build() {
            return new AuthorizerDefinition(this);
        }

        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder credentials(String credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder identitySource(String identitySource) {
            this.identitySource = identitySource;
            return this;
        }

        public Builder identityValidationExpression(String identityValidationExpression) {
            this.identityValidationExpression = identityValidationExpression;
            return this;
        }

        public Builder resultTtlInSeconds(Integer resultTtlInSeconds) {
            this.resultTtlInSeconds = resultTtlInSeconds;
            return this;
        }
    }
}

