/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.apigateway;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.aws.traits.apigateway.IntegrationResponse;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class MockIntegrationTrait
extends AbstractTrait
implements ToSmithyBuilder<MockIntegrationTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.apigateway#mockIntegration");
    private static final String PASS_THROUGH_BEHAVIOR_KEY = "passThroughBehavior";
    private static final String CONTENT_HANDLING_KEY = "contentHandling";
    private static final String REQUEST_PARAMETERS_KEY = "requestParameters";
    private static final String REQUEST_TEMPLATES_KEY = "requestTemplates";
    private static final String RESPONSES_KEY = "responses";
    private static final Set<String> KEYS = SetUtils.of((Object[])new String[]{"passThroughBehavior", "requestParameters", "requestTemplates", "responses"});
    private final String passThroughBehavior;
    private final String contentHandling;
    private final Map<String, String> requestParameters;
    private final Map<String, String> requestTemplates;
    private final Map<String, IntegrationResponse> responses;

    private MockIntegrationTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.passThroughBehavior = builder.passThroughBehavior;
        this.contentHandling = builder.contentHandling;
        this.requestParameters = MapUtils.copyOf((Map)builder.requestParameters);
        this.requestTemplates = MapUtils.copyOf((Map)builder.requestTemplates);
        this.responses = MapUtils.copyOf((Map)builder.responses);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getPassThroughBehavior() {
        return Optional.ofNullable(this.passThroughBehavior);
    }

    public Map<String, String> getAllRequestParameters() {
        return this.requestParameters;
    }

    public Optional<String> getRequestParameter(String expression) {
        return Optional.ofNullable(this.requestParameters.get(expression));
    }

    public Map<String, String> getAllRequestTemplates() {
        return this.requestTemplates;
    }

    public Optional<String> getRequestTemplate(String mimeType) {
        return Optional.ofNullable(this.requestTemplates.get(mimeType));
    }

    public Map<String, IntegrationResponse> getAllResponses() {
        return this.responses;
    }

    public Optional<IntegrationResponse> getResponse(String statusCode) {
        return Optional.ofNullable(this.responses.get(statusCode));
    }

    public Optional<String> getContentHandling() {
        return Optional.ofNullable(this.contentHandling);
    }

    protected ObjectNode createNode() {
        return Node.objectNode().withOptionalMember(PASS_THROUGH_BEHAVIOR_KEY, this.getPassThroughBehavior().map(Node::from)).withOptionalMember(CONTENT_HANDLING_KEY, this.getContentHandling().map(Node::from)).withOptionalMember(REQUEST_PARAMETERS_KEY, this.requestParameters.size() > 0 ? Optional.of(ObjectNode.fromStringMap(this.requestParameters)) : Optional.empty()).withOptionalMember(REQUEST_TEMPLATES_KEY, this.requestTemplates.size() > 0 ? Optional.of(ObjectNode.fromStringMap(this.requestTemplates)) : Optional.empty()).withOptionalMember(RESPONSES_KEY, this.responses.size() > 0 ? Optional.of((ObjectNode)this.responses.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, entry -> ((IntegrationResponse)entry.getValue()).toNode()))) : Optional.empty());
    }

    public Builder toBuilder() {
        return MockIntegrationTrait.builder().passThroughBehavior(this.passThroughBehavior).contentHandling(this.contentHandling).requestParameters(this.requestParameters).requestTemplates(this.requestTemplates).responses(this.responses);
    }

    public static final class Builder
    extends AbstractTraitBuilder<MockIntegrationTrait, Builder> {
        private String passThroughBehavior;
        private String contentHandling;
        private final Map<String, String> requestParameters = new HashMap<String, String>();
        private final Map<String, String> requestTemplates = new HashMap<String, String>();
        private final Map<String, IntegrationResponse> responses = new HashMap<String, IntegrationResponse>();

        public MockIntegrationTrait build() {
            return new MockIntegrationTrait(this);
        }

        public Builder passThroughBehavior(String passThroughBehavior) {
            this.passThroughBehavior = passThroughBehavior;
            return this;
        }

        public Builder contentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        public Builder putRequestParameter(String input, String output) {
            this.requestParameters.put(input, output);
            return this;
        }

        public Builder requestParameters(Map<String, String> requestParameters) {
            this.requestParameters.clear();
            this.requestParameters.putAll(requestParameters);
            return this;
        }

        public Builder removeRequestParameter(String expression) {
            this.requestParameters.remove(expression);
            return this;
        }

        public Builder putRequestTemplate(String mimeType, String template) {
            this.requestTemplates.put(mimeType, template);
            return this;
        }

        public Builder requestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates.clear();
            this.requestTemplates.putAll(requestTemplates);
            return this;
        }

        public Builder removeRequestTemplate(String mimeType) {
            this.requestTemplates.remove(mimeType);
            return this;
        }

        public Builder putResponse(String statusCodeRegex, IntegrationResponse integrationResponse) {
            this.responses.put(statusCodeRegex, integrationResponse);
            return this;
        }

        public Builder responses(Map<String, IntegrationResponse> responses) {
            this.responses.clear();
            this.responses.putAll(responses);
            return this;
        }

        public Builder removeResponse(String statusCodeRegex) {
            this.responses.remove(statusCodeRegex);
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            Builder builder = MockIntegrationTrait.builder();
            builder.sourceLocation((FromSourceLocation)value);
            ObjectNode node = value.expectObjectNode();
            node.warnIfAdditionalProperties((Collection)KEYS);
            node.getStringMember(MockIntegrationTrait.PASS_THROUGH_BEHAVIOR_KEY).map(StringNode::getValue).ifPresent(builder::passThroughBehavior);
            node.getStringMember(MockIntegrationTrait.CONTENT_HANDLING_KEY).map(StringNode::getValue).ifPresent(builder::contentHandling);
            node.getObjectMember(MockIntegrationTrait.REQUEST_PARAMETERS_KEY).map(ObjectNode::getMembers).ifPresent(members -> members.forEach((k, v) -> builder.putRequestParameter(k.getValue(), v.expectStringNode().getValue())));
            node.getObjectMember(MockIntegrationTrait.REQUEST_TEMPLATES_KEY).map(ObjectNode::getMembers).ifPresent(members -> members.forEach((k, v) -> builder.putRequestTemplate(k.getValue(), v.expectStringNode().getValue())));
            node.getObjectMember(MockIntegrationTrait.RESPONSES_KEY).map(ObjectNode::getMembers).ifPresent(members -> members.forEach((k, v) -> builder.putResponse(k.getValue(), IntegrationResponse.fromNode(v))));
            return builder.build();
        }
    }
}

