/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.model;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Tagging
implements ToSmithyBuilder<Tagging> {
    private final boolean taggable;
    private final boolean tagOnCreate;
    private final boolean tagUpdatable;
    private final String tagProperty;
    private final boolean cloudFormationSystemTags;
    private final Set<String> permissions;

    private Tagging(Builder builder) {
        this.taggable = builder.taggable;
        this.tagOnCreate = builder.tagOnCreate;
        this.tagUpdatable = builder.tagUpdatable;
        this.cloudFormationSystemTags = builder.cloudFormationSystemTags;
        this.tagProperty = builder.tagProperty;
        this.permissions = SetUtils.orderedCopyOf((Collection)builder.permissions);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean getTaggable() {
        return this.taggable;
    }

    public boolean getTagOnCreate() {
        return this.tagOnCreate;
    }

    public boolean getTagUpdatable() {
        return this.tagUpdatable;
    }

    public boolean getCloudFormationSystemTags() {
        return this.cloudFormationSystemTags;
    }

    public String getTagProperty() {
        return this.tagProperty;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public Builder toBuilder() {
        return Tagging.builder().taggable(this.taggable).tagOnCreate(this.tagOnCreate).tagUpdatable(this.tagUpdatable).cloudFormationSystemTags(this.cloudFormationSystemTags).tagProperty(this.tagProperty).permissions(this.permissions);
    }

    public static final class Builder
    implements SmithyBuilder<Tagging> {
        private boolean taggable;
        private boolean tagOnCreate;
        private boolean tagUpdatable;
        private boolean cloudFormationSystemTags;
        private String tagProperty;
        private final Set<String> permissions = new TreeSet<String>();

        public Tagging build() {
            return new Tagging(this);
        }

        public Builder taggable(boolean taggable) {
            this.taggable = taggable;
            return this;
        }

        public Builder tagOnCreate(boolean tagOnCreate) {
            this.tagOnCreate = tagOnCreate;
            return this;
        }

        public Builder tagUpdatable(boolean tagUpdatable) {
            this.tagUpdatable = tagUpdatable;
            return this;
        }

        public Builder cloudFormationSystemTags(boolean cloudFormationSystemTags) {
            this.cloudFormationSystemTags = cloudFormationSystemTags;
            return this;
        }

        public Builder tagProperty(String tagProperty) {
            this.tagProperty = tagProperty;
            return this;
        }

        public Builder permissions(Collection<String> permissions) {
            this.permissions.clear();
            this.permissions.addAll(permissions);
            return this;
        }

        public Builder addPermissions(Collection<String> permissions) {
            for (String permission : permissions) {
                this.addPermission(permission);
            }
            return this;
        }

        public Builder addPermission(String permission) {
            this.permissions.add(permission);
            return this;
        }

        public Builder clearPermissions() {
            this.permissions.clear();
            return this;
        }
    }
}

