/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.fromsmithy.mappers;

import java.util.Optional;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.CfnMapper;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.Context;
import software.amazon.smithy.aws.cloudformation.schema.model.ResourceSchema;
import software.amazon.smithy.aws.cloudformation.traits.CfnResource;
import software.amazon.smithy.aws.cloudformation.traits.CfnResourceIndex;
import software.amazon.smithy.aws.cloudformation.traits.CfnResourceProperty;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class RequiredMapper
implements CfnMapper {
    @Override
    public void before(Context context, ResourceSchema.Builder resourceSchema) {
        if (context.getConfig().getDisableRequiredPropertyGeneration()) {
            return;
        }
        Model model = context.getModel();
        StructureShape resourceStructure = context.getResourceStructure();
        for (MemberShape member : resourceStructure.members()) {
            if (!member.getMemberTrait(model, RequiredTrait.class).isPresent() || !this.hasWriteOrCreateMutability(context, member)) continue;
            resourceSchema.addRequired(context.getJsonSchemaConverter().toPropertyName(member));
        }
    }

    private boolean hasWriteOrCreateMutability(Context context, MemberShape member) {
        CfnResource cfnResource = context.getCfnResource();
        String memberId = (String)member.getId().toShapeId().getMember().get();
        Optional cfnResourceProperty = cfnResource.getProperty(memberId);
        return cfnResourceProperty.map(CfnResourceProperty::getMutabilities).map(mutabilities -> mutabilities.contains(CfnResourceIndex.Mutability.WRITE) || mutabilities.contains(CfnResourceIndex.Mutability.CREATE)).orElse(false);
    }
}

