/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.cloudformation.schema.fromsmithy;

import java.util.Locale;
import java.util.Map;
import software.amazon.smithy.aws.cloudformation.schema.CfnConfig;
import software.amazon.smithy.aws.cloudformation.schema.fromsmithy.CfnConverter;
import software.amazon.smithy.build.PluginContext;
import software.amazon.smithy.build.SmithyBuildPlugin;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;

public final class Smithy2Cfn
implements SmithyBuildPlugin {
    public String getName() {
        return "cloudformation";
    }

    public void execute(PluginContext context) {
        CfnConverter converter = CfnConverter.create();
        context.getPluginClassLoader().ifPresent(converter::classLoader);
        CfnConfig config = CfnConfig.fromNode((Node)context.getSettings());
        converter.config(config);
        Map<String, ObjectNode> resourceNodes = converter.convertToNodes(context.getModel());
        for (Map.Entry<String, ObjectNode> resourceNode : resourceNodes.entrySet()) {
            String filename = Smithy2Cfn.getFileNameFromResourceType(resourceNode.getKey());
            context.getFileManifest().writeJson(filename, (Node)resourceNode.getValue());
        }
    }

    static String getFileNameFromResourceType(String resourceType) {
        return resourceType.toLowerCase(Locale.US).replace("::", "-") + ".json";
    }
}

